<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Customize\Twig\Extension;

use Eccube\Entity\Order;
use Eccube\Entity\Shipping;
//use Eccube\Repository\OrderRepository;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class CustomizeOrderMailExtension extends AbstractExtension
{

    /**
     * Returns a list of functions to add to the existing list.
     *
     * @return TwigFunction[] An array of functions
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('get_shippings_for_mail', [$this, 'getShippingsForMail']),
        ];
    }

    /**
     * 受注の配送情報を取得する.
     *
     * @param Order $Order
     * @return Shipping[]
     */
    public function getShippingsForMail(Order $Order)
    {
        return $Order->getShippings();
    }
    
}
