<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Customize\Twig\Extension;

use Eccube\Entity\Order;
use Eccube\Entity\Shipping;
use Eccube\Repository\OrderRepository;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class CustomizeCustomerExtension extends AbstractExtension
{
    /**
     * Returns a list of functions to add to the existing list.
     *
     * @return TwigFunction[] An array of functions
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('orders_reverse', [$this, 'ordersReverse']),
            new TwigFunction('get_shipping', [$this, 'getShipping']),
        ];
    }

    /**
     * 顧客の購入履歴を新しい順に並べ替える
     *
     * @param Order[] $CustomerOrders
     * @return Order[]
     */
    public function ordersReverse($CustomerOrders)
    {
        $CustomerOrdersR = array();
        $count = count($CustomerOrders) - 1;        
        
        // array_reverse ではうまくいかなかったので以下の処理にした
        for ($i = 0; $i < count($CustomerOrders); $i++) {
            $CustomerOrdersR[$i] = $CustomerOrders[$count];
            $count = $count - 1;
        }
        
        return $CustomerOrdersR;
    }
    
    /**
     * 受注情報から配送情報を取得
     *
     * @param Order $Order
     * @return Shipping
     */
    public function getShipping($Order)
    {
        $Shippings = $Order->getShippings();
        
        return $Shippings[0];
    }
}
