<?php


namespace Plugin\ApteqPeriodical\Repository\Query;

use Eccube\Doctrine\Query\WhereClause;
use Eccube\Doctrine\Query\WhereCustomizer;
use Eccube\Repository\QueryKey;

class ApteqPeriodicalCustomizer extends WhereCustomizer
{
    /**
     * 販売タイプで絞り込み（通常商品/定期購入商品）
     *
     * @param array $params
     * @param $queryKey
     *
     * @return WhereClause[]
     */
    protected function createStatements($params, $queryKey)
    {
        $rtn = [];
        
        if (!empty($params['sale_type'])) {
            $rtn[] =  WhereClause::in('pc.SaleType', ':Sale_type', ['Sale_type' => $params['sale_type']]);
        }
        
        if (!empty($params['periodical_status'])) {            
            $rtn[] =  WhereClause::in('pr.periodical_status', ':PeriodicalStatus', ['PeriodicalStatus' => $params['periodical_status']]);
        }

        return $rtn;
    }

    /**
     * カスタマイズ対象のキーを返します。
     *
     * @return string
     */
    public function getQueryKey()
    {
        return QueryKey::ORDER_SEARCH_ADMIN;
    }
}