<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) Apteq CO.,LTD. All Rights Reserved.
 *
 */

namespace Plugin\ApteqPeriodical\Entity;

use Doctrine\ORM\Mapping as ORM;
use Eccube\Entity\AbstractEntity;
use Eccube\Entity\Order;
use Eccube\Entity\OrderItem;
use Eccube\Entity\Shipping;
use Plugin\ApteqPeriodical\Entity\PeriodicalDetail;

/**
 * ApteqPeriodical
 *
 * @ORM\Table(name="plg_apteq_periodical")
 * @ORM\Entity(repositoryClass="Plugin\ApteqPeriodical\Repository\PeriodicalRepository")
 */
class Periodical extends AbstractEntity
{

    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", options={"unsigned":true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="customer_id", type="integer", options={"unsigned":true}, nullable=true)
     */
    private $customer_id;
    
    /**
     * 継続状況
     *
     * @var int
     *
     * @ORM\Column(name="periodical_status", type="integer", options={"unsigned":true})
     */
    private $periodical_status;
    
    /**
     * 初回注文日
     *
     * @var \DateTime|null
     *
     * @ORM\Column(name="first_order_date", type="datetimetz", nullable=true)
     */
    private $first_order_date;
    
    /**
     * 何日おきか：1→１か月おき
     *
     * @var int
     *
     * @ORM\Column(name="shipping_interval", type="integer", options={"unsigned":true}, nullable=true)
     */
    private $shipping_interval;
    
    /**
     * @var int
     *
     * @ORM\Column(name="payment_total", type="integer", options={"unsigned":true}, nullable=true)
     */
    private $payment_total;
    
    /**
     * @var int
     *
     * @ORM\Column(name="product_id", type="integer", options={"unsigned":true}, nullable=true)
     */
    private $product_id;
    
    /**
     * @var int
     *
     * @ORM\Column(name="product_class_id", type="integer", options={"unsigned":true}, nullable=true)
     */
    private $product_class_id;
    
    /**
     * @var string
     *
     * @ORM\Column(name="classcategory_name01", type="string", length=255, nullable=true)
     */
    private $classcategory_name01;
    
    /**
     * @var string
     *
     * @ORM\Column(name="classcategory_name02", type="string", length=255, nullable=true)
     */
    private $classcategory_name02;
    
    /**
     * @var string
     *
     * @ORM\Column(name="note", type="string", length=255, nullable=true)
     */
    private $note;
    
    /**
     * @var \Eccube\Entity\Master\Country
     *
     * @ORM\ManyToOne(targetEntity="Eccube\Entity\Master\Country")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="country_id", referencedColumnName="id")
     * })
     */
    private $Country;
    /**
     * @var \Eccube\Entity\Master\Pref
     *
     * @ORM\ManyToOne(targetEntity="Eccube\Entity\Master\Pref")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pref_id", referencedColumnName="id")
     * })
     */
    private $Pref;
        
    /**
     * @var string
     *
     * @ORM\Column(name="name01", type="string", length=255)
     */
    private $name01;

    /**
     * @var string
     *
     * @ORM\Column(name="name02", type="string", length=255)
     */
    private $name02;

    /**
     * @var string
     *
     * @ORM\Column(name="kana01", type="string", length=255, nullable=true)
     */
    private $kana01;

    /**
     * @var string
     *
     * @ORM\Column(name="kana02", type="string", length=255, nullable=true)
     */
    private $kana02;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=true)
     */
    private $email;

    /**
     * @var string|null
     *
     * @ORM\Column(name="phone_number", type="string", length=14, nullable=true)
     */
    private $phone_number;

    /**
     * @var string|null
     *
     * @ORM\Column(name="postal_code", type="string", length=8, nullable=true)
     */
    private $postal_code;

    /**
     * @var string|null
     *
     * @ORM\Column(name="addr01", type="string", length=255, nullable=true)
     */
    private $addr01;

    /**
     * @var string|null
     *
     * @ORM\Column(name="addr02", type="string", length=255, nullable=true)
     */
    private $addr02;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_date", type="datetimetz")
     */
    private $create_date;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_date", type="datetimetz")
     */
    private $update_date;
    
    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
     * Set customer_id.
     *
     * @param int $customer_id
     *
     * @return Periodical
     */
    public function setCustomerId($customer_id)
    {
        $this->customer_id = $customer_id;

        return $this;
    }
    /**
     * Get customer_id.
     *
     * @return int
     */
    
    public function getCustomerId()
    {
        return $this->customer_id;
    }
    
    /**
     * Set periodical_status.
     *
     * @param int $periodical_status
     *
     * @return Periodical
     */
    public function setPeriodicalStatus($periodical_status)
    {
        $this->periodical_status = $periodical_status;

        return $this;
    }
    /**
     * Get periodical_status.
     *
     * @return int
     */
    public function getPeriodicalStatus()
    {
        return $this->periodical_status;
    }
    
     /**
     * Set first_order_date.
     *
     * @param \DateTime $first_order_date
     *
     * @return Periodical
     */
    public function setFirstOrderDate($first_order_date)
    {
        $this->first_order_date = $first_order_date;

        return $this;
    }
    /**
     * Get first_order_date.
     *
     * @return \DateTime
     */
    public function getFirstOrderDate()
    {
        return $this->first_order_date;
    }
    
    /**
     * Set shipping_interval.
     *
     * @param int $shipping_interval
     *
     * @return Periodical
     */
    public function setShippingInterval($shipping_interval)
    {
        $this->shipping_interval = $shipping_interval;

        return $this;
    }
    /**
     * Get shipping_interval.
     *
     * @return int
     */
    public function getShippingInterval()
    {
        return $this->shipping_interval;
    }
    
    /**
     * Set payment_total.
     *
     * @param int $payment_total
     *
     * @return Periodical
     */
    public function setPaymentTotal($payment_total)
    {
        $this->payment_total = $payment_total;

        return $this;
    }
    /**
     * Get payment_total.
     *
     * @return int
     */
    public function getPaymentTotal()
    {
        return $this->payment_total;
    }
    
    /**
     * Set product_id.
     *
     * @param int $product_id
     *
     * @return Periodical
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;

        return $this;
    }
    /**
     * Get product_id.
     *
     * @return int
     */
    public function getProductId()
    {
        return $this->product_id;
    }    
    /**
     * Set product_class_id.
     *
     * @param int $product_class_id
     *
     * @return Periodical
     */
    public function setProductClassId($product_class_id)
    {
        $this->product_class_id = $product_class_id;

        return $this;
    }
    /**
     * Get product_class_id.
     *
     * @return int
     */
    public function getProductClassId()
    {
        return $this->product_class_id;
    }
    /**
     * Set classcategory_name01.
     *
     * @param string $classcategory_name01
     *
     * @return Periodical
     */
    public function setClassCategoryName01($classcategory_name01)
    {
        $this->classcategory_name01 = $classcategory_name01;

        return $this;
    }
    /**
     * Get classcategory_name01.
     *
     * @return string
     */
    public function getClassCategoryName01()
    {
        return $this->classcategory_name01;
    }
    /**
     * Set classcategory_name02.
     *
     * @param string $classcategory_name02
     *
     * @return Periodical
     */
    public function setClassCategoryName02($classcategory_name02)
    {
        $this->classcategory_name02 = $classcategory_name02;

        return $this;
    }
    /**
     * Get classcategory_name02.
     *
     * @return string
     */
    public function getClassCategoryName02()
    {
        return $this->classcategory_name02;
    }
    /**
     * Set note.
     *
     * @param string|null $note
     *
     * @return Periodical
     */
    public function setNote($note = null)
    {
        $this->note = $note;

        return $this;
    }
    /**
     * Get note.
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
   
    /**
     * Set country.
     *
     * @param \Eccube\Entity\Master\Country|null $country
     *
     * @return Periodical
     */
    public function setCountry(\Eccube\Entity\Master\Country $country = null)
    {
        $this->Country = $country;

        return $this;
    }
    /**
     * Get country.
     *
     * @return \Eccube\Entity\Master\Country|null
     */
    public function getCountry()
    {
        return $this->Country;
    }

    /**
     * Set pref.
     *
     * @param \Eccube\Entity\Master\Pref|null $pref
     *
     * @return Periodical
     */
    public function setPref(\Eccube\Entity\Master\Pref $pref = null)
    {
        $this->Pref = $pref;

        return $this;
    }
    /**
     * Get pref.
     *
     * @return \Eccube\Entity\Master\Pref|null
     */
    public function getPref()
    {
        return $this->Pref;
    }
    
    /**
     * Set name01.
     *
     * @param string $name01
     *
     * @return Periodical
     */
    public function setName01($name01)
    {
        $this->name01 = $name01;

        return $this;
    }
    /**
     * Get name01.
     *
     * @return string
     */
    public function getName01()
    {
        return $this->name01;
    }

    /**
     * Set name02.
     *
     * @param string $name02
     *
     * @return Periodical
     */
    public function setName02($name02)
    {
        $this->name02 = $name02;

        return $this;
    }
    /**
     * Get name02.
     *
     * @return string
     */
    public function getName02()
    {
        return $this->name02;
    }

    /**
     * Set kana01.
     *
     * @param string $kana01
     *
     * @return Periodical
     */
    public function setKana01($kana01)
    {
        $this->kana01 = $kana01;

        return $this;
    }
    /**
     * Get kana01.
     *
     * @return string
     */
    public function getKana01()
    {
        return $this->kana01;
    }

    /**
     * Set kana02.
     *
     * @param string $kana02
     *
     * @return Periodical
     */
    public function setKana02($kana02)
    {
        $this->kana02 = $kana02;

        return $this;
    }
    /**
     * Get kana02.
     *
     * @return string
     */
    public function getKana02()
    {
        return $this->kana02;
    }

    /**
     * Set email.
     *
     * @param string|null $email
     *
     * @return Periodical
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    
    /**
     * Set phone_number.
     *
     * @param string|null $phone_number
     *
     * @return Periodical
     */
    public function setPhoneNumber($phone_number = null)
    {
        $this->phone_number = $phone_number;

        return $this;
    }

    /**
     * Get phone_number.
     *
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phone_number;
    }

    /**
     * Set postal_code.
     *
     * @param string|null $postal_code
     *
     * @return Periodical
     */
    public function setPostalCode($postal_code = null)
    {
        $this->postal_code = $postal_code;

        return $this;
    }

    /**
     * Get postal_code.
     *
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postal_code;
    }

    /**
     * Set addr01.
     *
     * @param string|null $addr01
     *
     * @return Periodical
     */
    public function setAddr01($addr01 = null)
    {
        $this->addr01 = $addr01;

        return $this;
    }

    /**
     * Get addr01.
     *
     * @return string|null
     */
    public function getAddr01()
    {
        return $this->addr01;
    }

    /**
     * Set addr02.
     *
     * @param string|null $addr02
     *
     * @return Periodical
     */
    public function setAddr02($addr02 = null)
    {
        $this->addr02 = $addr02;

        return $this;
    }
    /**
     * Get addr02.
     *
     * @return string|null
     */
    public function getAddr02()
    {
        return $this->addr02;
    }

    /**
     * Set shipping_time.
     *
     * @param string|null $shipping_time
     *
     * @return Periodical
     */
    public function setShippingTime($shipping_time = null)
    {
        $this->shipping_time = $shipping_time;

        return $this;
    }
    /**
     * Get shipping_time.
     *
     * @return string|null
     */
    public function getShippingTime()
    {
        return $this->shipping_time;
    }

    /**
     * Set create_date.
     *
     * @param \DateTime $create_date
     *
     * @return Periodical
     */
    public function setCreateDate($create_date)
    {
        $this->create_date = $create_date;

        return $this;
    }
    /**
     * Get create_date.
     *
     * @return \DateTime
     */
    public function getCreateDate()
    {
        return $this->create_date;
    }

    /**
     * Set update_date.
     *
     * @param \DateTime $updateDate
     *
     * @return Periodical
     */
    public function setUpdateDate($update_date)
    {
        $this->update_date = $update_date;

        return $this;
    }

    /**
     * Get updateDate.
     *
     * @return \DateTime
     */
    public function getUpdateDate()
    {
        return $this->update_date;
    }
    
    
}