<?php

namespace Plugin\AdminOrderPlus;

use Eccube\Event\TemplateEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Class Event
 * @package Plugin\AdminOrderPlus
 * @see https://umebius.com/eccube/v4-plugin-order_list_filter_shipping_date/
 */
class Event implements EventSubscriberInterface
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            '@admin/Order/index.twig' => 'adminOrderIndexTwig',
            '@admin/Order/edit.twig' => 'adminOrderEditTwig'
        ];
    }

    public function adminOrderIndexTwig(TemplateEvent $event)
    {
        $event->addSnippet('@AdminOrderPlus/admin/Order/index_js.twig');
    }
    
    public function adminOrderEditTwig(TemplateEvent $event)
    {
        $parameters = $event->getParameters();
        
        $Order = $parameters['Order'];
        $Shippings = $Order->getShippings();     
        
        $event->addSnippet('@AdminOrderPlus/admin/Order/edit_js.twig');
    }
}