<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) EC-CUBE CO.,LTD. All Rights Reserved.
 *
 * http://www.ec-cube.co.jp/
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Customize\Twig\Extension;

use Eccube\Entity\Order;
use Eccube\Entity\OrderItem;
use Eccube\Repository\TaxRuleRepository;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class CustomizeTaxExtension extends AbstractExtension
{
    /**
     * @var TaxRuleRepository
     */
    private $taxRuleRepository;

    /**
     * TaxExtension constructor.
     * @param TaxRuleRepository $taxRuleRepository
     */
    public function __construct(TaxRuleRepository $taxRuleRepository)
    {
        $this->taxRuleRepository = $taxRuleRepository;
    }

    /**
     * Returns a list of functions to add to the existing list.
     *
     * @return TwigFunction[] An array of functions
     */
    public function getFunctions()
    {
        return [
            new TwigFunction('is_reduced_tax_rate', [$this, 'isReducedTaxRate']),
            new TwigFunction('calc_tax_rate_total', [$this, 'CalcTaxRateTotal']),
            new TwigFunction('is_reduced_tax_product', [$this, 'isReducedTaxProcuct']),
        ];
    }

    /**
     * 明細が軽減税率対象かどうかを返す.
     *
     * 受注作成時点での標準税率と比較し, 異なれば軽減税率として判定する.
     *
     * @param OrderItem $OrderItem
     * @return bool
     */
    public function isReducedTaxRate(OrderItem $OrderItem)
    {
        $Order = $OrderItem->getOrder();

        /*
        $qb = $this->taxRuleRepository->createQueryBuilder('t');
        try {
            $TaxRule = $qb
                ->where('t.Product IS NULL AND t.ProductClass IS NULL AND t.apply_date < :apply_date')
                ->orderBy('t.apply_date', 'DESC')
                ->setParameter('apply_date', $Order->getCreateDate())
                ->setMaxResults(1)
                ->getQuery()
                ->getOneOrNullResult();
        } catch (\Exception $e) {
            return false;
        }

        return $TaxRule && $TaxRule->getTaxRate() != $OrderItem->getTaxRate();
        */
        
        /* 商品IDで軽減税率商品かどうか判定するように変更　2020.11 */
        /* フェムソイ（43,44）追加 2022.03 */
        /* メープルシロップ（45）追加 2022.10 */
        $tax8_products = [4,5,15,16,19,20,33,34,43,44,45];
        if (in_array($OrderItem['Product']['id'], $tax8_products, true)) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     *
     * 消費税８％と１０％に分けて集計する
     *
     * @param Order $Order
     * @return array
     */
    public function CalcTaxRateTotal(Order $Order)
    {
        /* フェムソイ（43,44）追加 2022.03 */
        /* メープルシロップ（45）追加 2022.10 */
        $tax8_products = [4,5,15,16,19,20,33,34,43,44,45]; //消費税 8% 商品のproduct_id
        
        $calc_tax_rate_total = array('tax8' => 0, 'tax10' => 0);
        
        $OrderItems_all = $Order['OrderItems'];
        //dump($OrderItems_all);exit;
        $i = 0;        
        foreach ($OrderItems_all as $OrderItem) {
            if ($OrderItem['Product']) {
                if (in_array($OrderItem['Product']['id'], $tax8_products, true)) {
                    $calc_tax_rate_total['tax8'] = $calc_tax_rate_total['tax8'] + $OrderItem['price'] * $OrderItem['quantity'];
                } else {
                    $calc_tax_rate_total['tax10'] = $calc_tax_rate_total['tax10'] + $OrderItem['price'] * $OrderItem['quantity'];
                }
            } else {
                $calc_tax_rate_total['tax10'] = $calc_tax_rate_total['tax10'] + $OrderItem['price'] * $OrderItem['quantity'];
            }           
        }
        
       return ($calc_tax_rate_total);
    }
    
    /**
     * 軽減税率対象商品かどうかを返す.
     *
     * @param int $ProductId
     * @return bool
     */
    public function isReducedTaxProcuct(int $ProductId)
    {
        /* フェムソイ（43,44）追加 2022.03 */
        /* メープルシロップ（45）追加 2022.10 */
        $tax8_products = [4,5,15,16,19,20,33,34, 43,44,45];
        if (in_array($ProductId, $tax8_products, true)) {
            return true;
        } else {
            return false;
        }
    }
}
