<?php

namespace Plugin\ApgSimpleCalendar\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Holidays
 *
 * @ORM\Table(name="plg_apg_simple_calendar_holidays")
 * @ORM\Entity(repositoryClass="Plugin\ApgSimpleCalendar\Repository\HolidaysRepository")
 */
class Holiday
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", options={"unsigned":true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="target_date", type="date")
     */
    private $target_date;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return null|string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param null|string $name
     * @return Holiday
     */
    public function setName(?string $name): Holiday
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getTargetDate(): ?\DateTime
    {
        return $this->target_date;
    }

    /**
     * @param \DateTime|null $target_date
     * @return Holiday
     */
    public function setTargetDate(?\DateTime $target_date): Holiday
    {
        $this->target_date = $target_date;
        return $this;
    }


}
