<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package apteq_original
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/favicon.ico" />
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/layouts/grid.css" type="text/css" />
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/js/sidr/jquery.sidr.light.css" type="text/css" />

<!-- google webfonts -->
<link href="https://fonts.googleapis.com/earlyaccess/sawarabimincho.css" rel="stylesheet" />
<link href="https://fonts.googleapis.com/earlyaccess/notosansjapanese.css" rel="stylesheet" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">

	<header id="header" class="nav-container noselect">
		
		<nav id="site-navigation" class="main-nav fade-out" role="navigation">
			<a id="right-menu" href="#right-menu">MENU</a>
						
			<div id="sidr-right" class="">

				<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu' ) ); ?>
				<!--<p class="menu-close">menu close</p>-->
			</div>
		</nav><!-- .site-navigation -->

		<div class="logo"><a href="<?php echo site_url(); ?>"><img src="<?php echo home_url( '/' ); ?>wp-content/themes/apteq_original/img/logo.jpg" alt="studio personal"></a></div>
		
	</header>

	<div class="site-content">
		<div class="nav-container inner-nav noselect">
			<nav id="site-navigation2" class="main-nav fade-in" role="navigation">
				<a id="right-menu2" href="#right-menu2">MENU</a>
							
				<div id="sidr-right2" class="">

					<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu2' ) ); ?>
					<!--<p class="menu-close">menu close</p>-->
				</div>
			</nav><!-- .site-navigation -->
			<div class="logo"><a href="<?php echo site_url(); ?>"><img src="<?php echo home_url( '/' ); ?>wp-content/themes/apteq_original/img/logo.jpg" alt="studio personal"></a></div>
		</div>
