<?php
/**
 * apteq_original functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package apteq_original
 */

if ( ! function_exists( 'apteq_original_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function apteq_original_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on apteq_original, use a find and replace
	 * to change 'apteq_original' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'apteq_original', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'menu-1' => esc_html__( 'Primary', 'apteq_original' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'apteq_original_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
}
endif;
add_action( 'after_setup_theme', 'apteq_original_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function apteq_original_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'apteq_original_content_width', 640 );
}
add_action( 'after_setup_theme', 'apteq_original_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function apteq_original_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'apteq_original' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'apteq_original' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'blog-Sidebar', 'apteq-original' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Add widgets here.', 'apteq-original' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'apteq_original_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function apteq_original_scripts() {
	wp_enqueue_style( 'apteq_original-style', get_stylesheet_uri(),array(), '2023072901' );

	wp_enqueue_script( 'jquery' );
	/*wp_enqueue_script( 'javascript',get_template_directory_uri().'/js/javascript.js',array('jquery'));*/

	wp_enqueue_script( 'apteq_original-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20170503', true );

	wp_enqueue_script( 'apteq_original-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

wp_enqueue_script( 'apteq_original-demo', get_template_directory_uri() . '/js/apteq.js', array(), '20170503', true );

/*wp_enqueue_script( 'apteq_original-scroll', get_template_directory_uri() . '/js/jquery.parallax-scroll.min.js', array(), '20170307', true );*/

$ua=$_SERVER['HTTP_USER_AGENT'];
if ((strpos($ua, 'iPhone') !== false) || ((strpos($ua, 'Android') !== false) && (strpos($ua, 'Mobile') !== false))
|| (strpos($ua, 'Windows Phone') !== false)
|| (strpos($ua, 'BlackBerry') !== false)) {
	/* sp */	
} else {
	/* pc *//* 2023.07 いったん使用をやめる
    /* wp_enqueue_script( 'apteq_original-scroll', get_template_directory_uri() . '/js/skrollr.js', array(), '20170510', true ); */
}

wp_enqueue_script( 'apteq_original-sidr', get_template_directory_uri() . '/js/sidr/jquery.sidr.min.js', array(), '20170119', true );
wp_enqueue_script( 'apteq_original-slick', get_template_directory_uri() . '/js/slick/slick.min.js', array('jquery'), '20230726', true );
wp_enqueue_style( 'apteq_original-slick-style', get_template_directory_uri() . '/js/slick/slick.css' );

wp_enqueue_script( 'apteq_original-sidr', get_template_directory_uri() . '/js/sidr/jquery.sidr.min.js', array(), '20170119', true );

	/********** 追加 **************/
	wp_enqueue_script( 'apteq_original-webfonts','//webfonts.sakura.ne.jp/js/sakura.js',array());

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}

add_action( 'wp_enqueue_scripts', 'apteq_original_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
/**
 * add script 追加
 */
// function my_js_function() {
// echo <<< EOM
// <script type="text/javascript">
// var s = skrollr.init();
// </script>
// EOM;
// }
add_action( 'wp_print_footer_scripts', 'my_js_function' );
/**
 * shortcode
 */
//TOPページ
add_shortcode('siteurl', 'shortcode_siteurl');
function shortcode_siteurl() {
	return site_url( '/' );
}
add_shortcode('homeurl', 'shortcode_homeurl');
function shortcode_homeurl() {
	return home_url( '/' );
}
