<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package apteq_original
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/layouts/grid.css" type="text/css" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'apteq_original' ); ?></a>

	<header id="header" class="nav-container noselect">
		<nav id="site-navigation" class="main-navigation main-nav fade-out" role="navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Primary Menu', 'apteq_original' ); ?></button>
				<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu' ) ); ?>
		</nav><!-- #site-navigation -->

		<!--<nav class="main-nav">
			<ul>
				<li class="fade-out">
					<a href="./index.html"  class="current">Top</a>
				</li>
				<li class="fade-out">
					<a href="./index.html#anc1">Data-driven</a>
				</li>
				<li class="fade-out">
					<a href="./index.html#anc2">Case</a>
				</li>
				<li class="fade-out">
					<a href="./index.html#anc3">Service</a>
				</li>
				<li class="fade-out">
					<a href="./index.html#anc4">Contact</a>
				</li>
			</ul>
		</nav>-->
		<div class="logo"><img src="/di/wp-content/themes/apteq_original/img/favicon.png" alt="datainnovation"></div>
	</header>

	<div class="site-content">
		<div class="nav-container inner-nav noselect">
			<nav id="site-navigation" class="main-navigation main-nav fade-in" role="navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Primary Menu', 'apteq_original' ); ?></button>
				<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu' ) ); ?>
			</nav><!-- #site-navigation -->
			<div class="logo"><img src="/di/wp-content/themes/apteq_original/img/favicon.png" alt="datainnovation"></div>
		</div>
