<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package apteq_original
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php apteq_original_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<div class="m-all t-1of2 d-3of5">
			<?php
				the_content( sprintf(
					/* translators: %s: Name of current post. */
					wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'apteq_original' ), array( 'span' => array( 'class' => array() ) ) ),
					the_title( '<span class="screen-reader-text">"', '"</span>', false )
				) );

				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'apteq_original' ),
					'after'  => '</div>',
				) );
			?>
		</div>
		<div class="m-all t-1of2 d-2of5">
			<?php if ( has_post_thumbnail( $thumbnail->ID ) ) { ?>
				<div class="alignright"><?php the_post_thumbnail('large'); ?></div>
			<?php } ?>
		</div>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php apteq_original_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
