<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "TOP";
/*
try {
	$pdo = DBopen();

	// 今までにどれだけ記録があるかを調べる
	$count_asa_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '04:00:00' AND created_time < '11:00:00' AND deleted != 1";
	$count_asa = $pdo->prepare($count_asa_sql);
	$count_asa->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$count_asa->execute();
	$count_asa_result = $count_asa->fetchcolumn();

	$count_hiru_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '11:00:00' AND created_time < '17:00:00' AND deleted != 1";
	$count_hiru = $pdo->prepare($count_hiru_sql);
	$count_hiru->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$count_hiru->execute();
	$count_hiru_result = $count_hiru->fetchcolumn();

	// 夜の記録の場合は0～4時の記録を前日にするために調整する
	$count_yoru_sql = "SELECT COUNT(DISTINCT CAST((created - INTERVAL 4 HOUR) AS DATE)) FROM report WHERE user_id = ? AND (created_time < '04:00:00' OR created_time >= '17:00:00') AND deleted != 1";
	$count_yoru = $pdo->prepare($count_yoru_sql);
	$count_yoru->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$count_yoru->execute();
	$count_yoru_result = $count_yoru->fetchcolumn();

} catch (Exception $e) {
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}
*/

if(isset($_SESSION["info"]["save"])){
	// 初回登録用
	unset($_SESSION["info"]["save"]);
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>
	<div id="main">
		<div id="top_header_text">
			<div class="heading">入籍指輪システム</div>
			<div class="small_text">※特許申請中</div>
		</div>
		<p class="top_text center">
			<span class="ib">"フィット率"</span>と<span class="ib">"むくみ率"</span>で<span class="ib">着け心地をデータ解析</span>
		</p>
		<div id="top_box">
			<div>
				<img src="./stamps/main.png" width="100%">
			</div>
			<div id="top_list">
				<div class="top_button_dummy"></div>
				<a href="./report.php" class="button_circle">記録を取る</a>
				<a href="./list.php" class="button_circle">記録の一覧</a>
				<a href="./aggregate.php" class="button_circle">解析結果</a>
				<div class="top_button_dummy"></div>
			</div>
		</div>
		<div class="top_separation"></div>
		<div class="top_text">
			<ul class="top_text_list">
				<li>朝1回、昼1回、夜1回と記録を取るごとにアイテムが増えていきます。</li>
				<li>まずはスタンプラリーの完成を目指しましょう。</li>
				<li>完成後も記録を取り続けるとより正確な分析結果が出ます。</li>
			</ul>
		</div>
	</div>
</body>
</html>
