<?php
$title = "スタンプアニメーションにしたい3";

$accessories_img_1 = [
	"pigeon.png",
	"ring.png",
	"bell.png",
	"bouquet.png",
	"written.png",
];

$accessories_img_2 = [
	"written.png",
	"bouquet.png",
	"bell.png",
	"ring.png",
	"pigeon.png",
];

$accessories_img_3 = [
	"written.png",
	"bouquet.png",
	"bell.png",
	"ring.png",
	"pigeon.png",
];


$date = new DateTime();
$date = $date->format("YmdHis");

$json_accessories_img_1 = json_encode($accessories_img_1);
$json_accessories_img_2 = json_encode($accessories_img_2);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js?v=<?=$date?>"></script>
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
var item1_count = 0;
var item2_count = 0;
var item3_count = 0;
const accessories_img_1_list = <?=$json_accessories_img_1?>;
const accessories_img_2_list = <?=$json_accessories_img_2?>;

function main_img(){
	/*
	if(item1_count == 0 && item2_count == 0 && item3_count == 0){
		let img_elm = document.getElementById("main_img");
		if(img_elm){
			img_elm.src = "./stamps/main.png";
			img_elm.classList.add("stamp_motion");
		}
	}
	*/
}

function item1_accessory(){
	console.log("item1");
	main_img();

	if(item1_count < 0){
		item1_count = 0;
	}
	if(item1_count > 4){
		item1_count = 4;
	}
	let img_elm = document.getElementById("accessories_img_1_"+item1_count);
	if(img_elm){
		let img_src = "item1_" + (item1_count + 1);
		img_elm.src = "./stamps/" + img_src + ".png";
		img_elm.classList.add("stamp_motion");
		item1_count++;
	}

	finish_img();
	count_img(1);
}

function item2_accessory(){
	console.log("item2");
	main_img();

	if(item2_count < 0){
		item2_count = 0;
	}
	if(item2_count > 4){
		item2_count = 4;
	}
	let img_elm = document.getElementById("accessories_img_2_"+item2_count);
	if(img_elm){
		let img_src = "item2_" + (item2_count + 1);
		img_elm.src = "./stamps/" + img_src + ".png";
		img_elm.classList.add("stamp_motion");
		item2_count++;
	}

	finish_img();
	count_img(2);
}

function item3_accessory(){
	console.log("item3");
	main_img();

	if(item3_count < 0){
		item3_count = 0;
	}
	if(item3_count > 4){
		item3_count = 4;
	}
	let img_elm = document.getElementById("accessories_img_3_"+item3_count);
	if(img_elm){
		let img_src = "item3_" + (item3_count + 1);
		img_elm.src = "./stamps/" + img_src + ".png";
		img_elm.classList.add("stamp_motion");
		item3_count++;
	}

	finish_img();
	count_img(3);
}

function finish_img(){
	if(item1_count >= 5 && item2_count >= 5 && item3_count >= 5){
		// 両方終わっている
		let img_elm = document.getElementById("finish_img");
		if(img_elm){
			let img_src = "finish.png";
			img_elm.src = "./stamps/" + img_src;
			img_elm.classList.add("finish_motion");
		}
		let frame_elm = document.getElementById("frame_img");
		if(frame_elm){
			let frame_src = "frame.png";
			frame_elm.src = "./stamps/" + frame_src;
			frame_elm.classList.add("finish_motion");
		}
	}
}

function count_img(e){
	let elm;
	let value;
	if(item1_count >= 5 && item2_count >= 5 && item3_count >= 5){
		elm = document.getElementById("count_box");
		value = "記録を取り続けることでより正確な結果が確認できます。";
	} else {
		elm = document.getElementById("count"+e);
		switch(e){
			case 1:
			value = 5 - item1_count;
			break;
			case 2:
			value = 5 - item2_count;
			break;
			case 3:
			value = 5 - item3_count;
			break;
		}
		if(value < 0){
			value = 0;
		}
	}
	elm.textContent = value;
}
window.onload = function(){
	count_img(1);
	count_img(2);
	count_img(3);
}
</script>
<style>
#stamp_box {
	position: relative;
	width: 90%;
	max-width: 700px;
	/*height: 400px;*/
	margin: auto;
}

img {
	image-rendering: -webkit-optimize-contrast;
}

#base_img {
	width: 100%;
	/*height: 100%;*/
	/*
	position: absolute;
	top: 10%;
	right: 0;
	left: 0;
	margin: auto;
	z-index: 10;
	*/
}
#main_img {
	position: absolute;
	bottom: 10%;
	right: 0;
	left: 0;
	margin: auto;
	height: 60%;
	width: auto;
}
#finish_img {
	width: 35%;
	position: absolute;
	top: 0;
	right: 0;
	left: 0;
	margin: auto;
}

#accessories_img_1_0 {
	position: absolute;
	bottom: 8%;
	left: 5%;
}
#accessories_img_1_1 {
	position: absolute;
	bottom: 8%;
	left: 21%;
}
#accessories_img_3_0 {
	position: absolute;
	bottom: 34%;
	left: 5%;
}
#accessories_img_3_2 {
	position: absolute;
	bottom: 34%;
	left: 21%;
}
#accessories_img_1_3 {
	position: absolute;
	bottom: 80%;
	left: 5%;
}

#accessories_img_1_4 {
	position: absolute;
	top: 16%;
	right: 0;
	left: 0;
	margin: auto;
	width: 22%;
}
#accessories_img_2_1 {
	position: absolute;
	bottom: 64%;
	right: 10%;
}
#accessories_img_2_3 {
	position: absolute;
	bottom: 60%;
	left: 21%;
	width: 10%;
}
#accessories_img_3_1 {
	position: absolute;
	bottom: 32.5%;
	right: 5%;
}
#accessories_img_2_0 {
	position: absolute;
	bottom: 8%;
	right: 4%;
}

#accessories_img_2_2 {
	position: absolute;
	bottom: 8%;
	right: 24%;
	width: 10%;
}
#accessories_img_1_2 {
	position: absolute;
	bottom: 38%;
	right: 24%;
	width: 10%;
}
#accessories_img_3_3 {
	position: absolute;
	bottom: 24%;
	right: 16%;
	width: 10%;
}
#accessories_img_2_4 {
	position: absolute;
	bottom: 80%;
	right: 5%;
}
#accessories_img_3_4 {
	position: absolute;
	bottom: 53%;
	right: 0;
	left: 0;
	margin: auto;
	width: 50%;
}

#frame_img {
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
}
.accessory_img {
	width: 15%;
}


#count_box {
	margin: auto;
	padding: 10px;
	max-width: 600px;

}


.stamp_motion {
	animation: stamp_animation 2s paused both;
	animation-play-state: running;
}

.finish_motion {
	animation: finish_animation 1.5s paused both;
	animation-play-state: running;
}

@keyframes stamp_animation {
	0% {
		visibility:visible;
		opacity: 0;
		transform:  rotate(-30deg) scale(2.5);
	}
	30% {
		visibility:visible;
		opacity: 0.8;
		transform:  rotate(5deg) scale(1.04);
	}
	100% {
		visibility:visible;
		opacity: 1.0;
		transform: rotate(0deg);
	}
}

@keyframes finish_animation {
	0% {
		visibility:visible;
		opacity: 0;
		transform: scale(2.5);
	}
	30% {
		visibility:visible;
		opacity: 0;
		/*transform:  rotate(5deg) scale(1.04);*/
	}
	50% {
		visibility:visible;
		opacity: 0.5;
		/*transform:  rotate(5deg) scale(1.04);*/
	}
	100% {
		visibility:visible;
		opacity: 1.0;
		transform: rotate(0deg) scale(1);
	}
}
</style>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="main">
		<div id="stamp_box">
			<img src="./stamps/base.png" id="base_img">
			<img src="./stamps/main.png" id="main_img">
			<?php
			for($i=0;$i<5;$i++){
				$count = $i + 1;
				/*
				echo "<img src=\"./stamps/item1_{$count}.png\" id=\"accessories_img_1_{$i}\" class=\"accessory_img\">";
				echo "<img src=\"./stamps/item2_{$count}.png\" id=\"accessories_img_2_{$i}\" class=\"accessory_img\">";
				echo "<img src=\"./stamps/item3_{$count}.png\" id=\"accessories_img_3_{$i}\" class=\"accessory_img\">";
				*/
				echo "<img src=\"\" id=\"accessories_img_1_{$i}\" class=\"accessory_img\">";
				echo "<img src=\"\" id=\"accessories_img_2_{$i}\" class=\"accessory_img\">";
				echo "<img src=\"\" id=\"accessories_img_3_{$i}\" class=\"accessory_img\">";
			}
			?>
			<img src="" id="finish_img">
			<img src="" id="frame_img">
		</div>
	</div>
	<p id="count_box">
		集計結果の算出まで<br>
		朝残り<span id="count1"></span>回<br>
		昼残り<span id="count2"></span>回<br>
		夜残り<span id="count3"></span>回
	</p>
	<p style="text-align: center;"><button onclick="item1_accessory()">朝の記録</button></p>
	<p style="text-align: center;"><button onclick="item2_accessory()">昼の記録</button></p>
	<p style="text-align: center;"><button onclick="item3_accessory()">夜の記録</button></p>
	<p class="center"><a href="./stamp3.php"><button>カウントリセット</button></a></p>
	<p>画像が更新されていない場合はブラウザのキャッシュをクリアしてください</p>
</body>
</html>
