<?php
$title = "スタンプアニメーションにしたい2";

$accessories_img_1 = [
	"pigeon.png",
	"ring.png",
	"bell.png",
	"bouquet.png",
	"written.png",
];

$accessories_img_2 = [
	"written.png",
	"bouquet.png",
	"bell.png",
	"ring.png",
	"pigeon.png",
];


$date = new DateTime();
$date = $date->format("YmdHis");

$json_accessories_img_1 = json_encode($accessories_img_1);
$json_accessories_img_2 = json_encode($accessories_img_2);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js?v=<?=$date?>"></script>
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
var left_count = 0;
var right_count = 0;
const accessories_img_1_list = <?=$json_accessories_img_1?>;
const accessories_img_2_list = <?=$json_accessories_img_2?>;

function left_accessory(){
	console.log("left");
	if(left_count < 0){
		left_count = 0;
	}
	if(left_count > 4){
		left_count = 4;
	}
	let img_elm = document.getElementById("accessories_img_1_"+left_count);
	if(img_elm){
		let img_src = accessories_img_1_list[left_count];
		img_elm.src = "./img/" + img_src;
		img_elm.classList.add("stamp_motion");
		left_count++;
	}

	finish_img();
}

function right_accessory(){
	console.log("right");
	if(right_count < 0){
		right_count = 0;
	}
	if(right_count > 4){
		right_count = 4;
	}
	let img_elm = document.getElementById("accessories_img_2_"+right_count);
	if(img_elm){
		let img_src = accessories_img_2_list[right_count];
		img_elm.src = "./img/" + img_src;
		img_elm.classList.add("stamp_motion");
		right_count++;
	}

	finish_img();
}

function finish_img(){
	if(right_count >= 5 && left_count >= 5){
		// 両方終わっている
		let img_elm = document.getElementById("finish_img");
		if(img_elm){
			let img_src = "finish.png";
			img_elm.src = "./img/" + img_src;
		}
	}
}
</script>
<style>
#stamp_box {
	position: relative;
	width: 90%;
	max-width: 380px;
	height: 400px;
	margin: auto;
}

img {
	image-rendering: -webkit-optimize-contrast;
}

#base_img {
	width: 75%;
	/*height: 100%;*/
	position: absolute;
	top: 10%;
	right: 0;
	left: 0;
	margin: auto;
	z-index: 10;
}

#accessories_img_1_0 {
	position: absolute;
	bottom: 30%;
	left: 0;
}
#accessories_img_1_1 {
	position: absolute;
	bottom: 42.5%;
	left: 0;
}
#accessories_img_1_2 {
	position: absolute;
	bottom: 55%;
	left: 0;
}
#accessories_img_1_3 {
	position: absolute;
	bottom: 67.5%;
	left: 0;
}
#accessories_img_1_4 {
	position: absolute;
	bottom: 80%;
	left: 0;
}

#accessories_img_2_0 {
	position: absolute;
	bottom: 30%;
	right: 0;
}
#accessories_img_2_1 {
	position: absolute;
	bottom: 42.5%;
	right: 0;
}
#accessories_img_2_2 {
	position: absolute;
	bottom: 55%;
	right: 0;
}
#accessories_img_2_3 {
	position: absolute;
	bottom: 67.5%;
	right: 0;
}
#accessories_img_2_4 {
	position: absolute;
	bottom: 80%;
	right: 0;
}
.accessory_img {
	width: 15%;
}

#finish_img {
	width: 35%;
	position: absolute;
	bottom: 0;
	right: 0;
	left: 0;
	margin: auto;
}

.stamp_motion {
	animation: stamp_animation 2s paused both;
	animation-play-state: running;
}

@keyframes stamp_animation {
	0% {
		visibility:visible;
		opacity: 0;
		transform:  rotate(-30deg) scale(2.5);
	}
	30% {
		visibility:visible;
		opacity: 0.8;
		transform:  rotate(5deg) scale(1.04);
	}
	100% {
		visibility:visible;
		opacity: 1.0;
		transform: rotate(0deg);
	}
}
</style>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="main">
		<div id="stamp_box">
			<img src="./img/silhouette.png" id="base_img">
			<?php
			$i = 0;
			foreach($accessories_img_1 as $accessory_img_1){
				//echo "<img src=\"./img/{$accessory_img_1}\" id=\"accessories_img_1_{$i}\">";
				echo "<img src=\"\" id=\"accessories_img_1_{$i}\" class=\"accessory_img\">";
				$i++;
			}
			$i = 0;
			foreach($accessories_img_2 as $accessory_img_2){
				//echo "<img src=\"./img/{$accessory_img_2}\" id=\"accessories_img_2_{$i}\">";
				echo "<img src=\"\" id=\"accessories_img_2_{$i}\" class=\"accessory_img\">";
				$i++;
			}
			?>
			<img src="" id="finish_img">
		</div>
	</div>
	<p style="text-align: center;"><button onclick="left_accessory()">朝の記録</button></p>
	<p style="text-align: center;"><button onclick="right_accessory()">夜の記録</button></p>
	<p class="center"><a href="./stamp2.php"><button>カウントリセット</button></a></p>
</body>
</html>
