<?php
session_start();

$count = filter_input(INPUT_POST,"count");
if(empty($count)){
	$count = 0;
}

$title = "スタンプアニメーションにしたい";
$star = $count;

$count++;
$_SESSION["count"] = $count;

$date = new DateTime();
$date = $date->format("YmdHis");
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js?v=<?=$date?>"></script>
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
var star_count = <?=$star?>;
function star(){
	console.log("★");
	let img_elm = document.getElementById("img"+star_count);
	if(img_elm){
		img_elm.src = "./img/star.png";
		img_elm.classList.add("stamp_star");
	}
	star_count++;
}
window.onload = function(){
	// 画面が開いたらスタンプを押す
	//star();
	// 開いたときは少し遅延が入った方がいいか？
	window.setTimeout(star, 200);
}
</script>
<style>
html,body {
	margin: 0;
}
#stamp_box {
	max-width: 600px;
	margin: auto;
	display: flex;
	flex-wrap: wrap;
}
.star_icon_box {
	width: 20%;
	text-align: center;
}
.star_img {
	width: 50px;
}
.stamp_star {
	animation: stamp_animation 2s paused both;
	animation-play-state: running;
}

@keyframes stamp_animation {
	0% {
		visibility:visible;
		opacity: 0;
		transform:  rotate(-30deg) scale(2.5);
	}
	30% {
		visibility:visible;
		opacity: 0.8;
		transform:  rotate(5deg) scale(1.04);
	}
	100% {
		visibility:visible;
		opacity: 1.0;
		transform: rotate(0deg);
	}
}
</style>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="main">
		<div id="stamp_box">
			<?php
			for($i=0;$i<20;$i++){
				if($i < $star){
					$img = "star.png";
				} else {
					$img = "star_empty.png";
				}
				echo "<div id=\"block{$i}\" class=\"star_icon_box\"><img src=\"./img/{$img}\" id=\"img{$i}\" class=\"star_img\"></div>";
			}
			?>
		</div>
	</div>
	<p style="text-align: center;"><button onclick="star()">★</button></p>
	<p class="center"><a href="./?r=Y"><button>戻る</button></a></p>
	<p class="center"><a href="./stamp.php"><button>カウントリセット</button></a></p>
</body>
</html>
