<?php
$column_values = [
	110,
	120,
	10,
];
$column_names = [
	"サイズアップ",
	"そのまま",
	"サイズダウン",
];
$number = count($column_values);
$column_values_json = json_encode($column_values);
?>
<!DOCTYPE html>
<html lang="ja">

<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<title>グラフ</title>
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<link href="./css/style.css" rel="stylesheet">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="./c3-0.7.18/c3.css" rel="stylesheet">
<script src="./d3/d3.min.js"></script>
<script src="./c3-0.7.18/c3.min.js"></script>
<style>
tspan.donut-chart-title-header {
  font-size: 2em;
}
.legend span {
    width: 33.333333%;
    display: inline-block;
    text-align: center;
    cursor: pointer;
    color: white;
}
.c3-chart-arc path {
    stroke-width: 0;
}
</style>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="main">
		<span class="content_title center">サイズ調整</span>
		<p>貴方のタイプの場合では他の方はサイズ調整をこのように行いました。</p>
		<div id="donut"></div>

		<span class="content_title center mt20px">指当たり</span>
		<p class="finger_touch_text">貴方の内側の指あたりに問題はないと思われます。<br>気になる方はご相談ください。</p>
		<p class="finger_touch_text attention">貴方の外側の指あたりに問題がある可能性があると思われます。<br>担当にご相談ください。</p>
	</div>
	<script>
	var values = <?php echo $column_values_json; ?>;
	var columns = [];
	var names = {};
	let sum = 0;

	for(var i=1;i<=values.length;i++){
		var value = values[i-1];
		var data_num = "data" + i;
		var data_name = "データ" + i;
		var column = [data_num, value];
		columns.push(column);
		names[data_num] = data_name;
		sum += value;
	}

	var donut = c3.generate({
		bindto: '#donut',
		data: {
			columns: [
				<?php
				for($i=0;$i<$number;$i++){
					$column = $column_values[$i];
					$num = $i + 1;

					echo "['data{$num}', {$column}],\n";
				}
				?>
			],
			names: {
				<?php
				for($i=0;$i<$number;$i++){
					$name = $column_names[$i];
					$num = $i + 1;

					echo "data{$num}: \"{$name}\",\n";
				}
				?>
			},
			type : 'pie',
			order : null,
			/*
			colors: {
				data1: '#ff0000',
				data2: '#00ff00',
				data3: '#0000ff'
			},
			*/
			onclick: function (d, i) { console.log("onclick", d, i); },
			onmouseover: function (d, i) { console.log("onmouseover", d, i); },
			onmouseout: function (d, i) { console.log("onmouseout", d, i); }
		},
		legend: {
			//position: 'right',
			item: {
				onclick: function(data){
					// do not toggle
				}
			}
		},
	});
	</script>
</body>
</html>
