<?php
// 記録データからユーザーのタイプを診断する
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

require_once '../include/include.php';
require_once '../include/calc.php';

/************************************
* 記録からユーザーのタイプを計算する *
* 必要なのは                        *
* ・着け外しのデータ                *
* ・装着感のデータ                  *
* ・着け外し頻度                    *
* ・飲酒頻度                        *
* ・フィットの好み                  *
************************************/

$title = "ユーザータイプ";
$date = new DateTime();
$date = $date->format("YmdHis");

try {
	$pdo = DBopen();

	// 確定したデータしかサイズの調整結果が出ない
	// ここでは確定者のタイプを算出して比較対象とするためのものを作る
	$select_user_sql = "SELECT * FROM user WHERE 1";
	$select_user = $pdo->query($select_user_sql);

	while($user_row = $select_user->fetch()){
		$user_id = $user_row["user_id"];
		$return_data = diagnosis($pdo,$user_id);
		$user_type1 = $return_data["user_type1"];
		$user_type1_value = $return_data["user_type1_value"];
		$user_type2 = $return_data["user_type2"];
		$user_type2_value = $return_data["user_type2_value"];
		$user_type3 = $return_data["user_type3"];

		echo "{$user_id} : {$user_type3} : ({$user_type1_value},{$user_type2_value})";
		echo "<br>";
	}

} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}
