<?php
// テスト用のデータ
// ランダムで取得するには
// $array[array_rand($array)]
// array_rand は key をランダムに取り出すもの
// 古いバージョン対策として
// $array(rand(0,(count($array) - 1)))とかも用意する？
// 性別は 0 -> 男性, 1 -> 女性 として扱う
// 実際のシステムで扱いやすいように数字で返す

require_once './address_list.php';

// 姓は性別によって変わることはない
$sei_list = [
	'佐藤',
	'鈴木',
	'高橋',
	'田中',
	'伊藤',
	'渡辺',
	'山本',
	'中村',
	'小林',
	'加藤',
	'吉田',
	'山田',
	'佐々木',
	'山口',
	'松本',
	'井上',
	'木村',
	'林',
	'斎藤',
	'清水',
	'山崎',
	'森',
	'池田',
	'橋本',
	'阿部',
	'石川',
	'山下',
	'中島',
	'石井',
	'小川',
	'前田',
	'岡田',
	'長谷川',
	'藤田',
	'後藤',
	'近藤',
	'村上',
	'遠藤',
	'青木',
	'坂本',
	'福田',
	'太田',
	'西村',
	'藤井',
	'岡本',
	'藤原',
	'金子',
	'三浦',
	'中野',
	'中川',
	'原田',
];

$sei_eng_list = [
	'satou',
	'suzuki',
	'takahashi',
	'tanaka',
	'itou',
	'watanabe',
	'yamamoto',
	'nakamura',
	'kobayashi',
	'katou',
	'yoshida',
	'yamada',
	'sasaki',
	'yamaguchi',
	'matumoto',
	'inoue',
	'kimura',
	'hayashi',
	'saitou',
	'simizu',
	'yamazaki',
	'mori',
	'ikeda',
	'hashimoto',
	'abe',
	'ishikawa',
	'yamashita',
	'nakajima',
	'ishii',
	'ogawa',
	'maeda',
	'okada',
	'hasegawa',
	'hujita',
	'gotou',
	'kondou',
	'murakami',
	'endou',
	'aoki',
	'sakamoto',
	'hukuda',
	'ooda',
	'nishimura',
	'hujii',
	'okamoto',
	'hujiwara',
	'kaneko',
	'miura',
	'nakano',
	'nakagawa',
	'harada',
];

$sei_kana_list_1 = [
	'さとう',
	'すずき',
	'たかはし',
	'たなか',
	'いとう',
	'わたなべ',
	'やまもと',
	'なかむら',
	'こばやし',
	'かとう',
	'よしだ',
	'やまだ',
	'ささき',
	'やまぐち',
	'まつもと',
	'いのうえ',
	'きむら',
	'はやし',
	'さいとう',
	'しみず',
	'やまざき',
	'もり',
	'いけだ',
	'はしもと',
	'あべ',
	'いしかわ',
	'やました',
	'なかじま',
	'いしい',
	'おがわ',
	'まえだ',
	'おかだ',
	'はせがわ',
	'ふじた',
	'ごとう',
	'こんどう',
	'むらかみ',
	'えんどう',
	'あおき',
	'さかもと',
	'ふくだ',
	'おおた',
	'にしむら',
	'ふじい',
	'おかもと',
	'ふじわら',
	'かねこ',
	'みうら',
	'なかの',
	'なかがわ',
	'はらだ',
];

$sei_kana_list_2 = [
	'サトウ',
	'スズキ',
	'タカハシ',
	'タナカ',
	'イトウ',
	'ワタナベ',
	'ヤマモト',
	'ナカムラ',
	'コバヤシ',
	'カトウ',
	'ヨシダ',
	'ヤマダ',
	'ササキ',
	'ヤマグチ',
	'マツモト',
	'イノウエ',
	'キムラ',
	'ハヤシ',
	'サイトウ',
	'シミズ',
	'ヤマザキ',
	'モリ',
	'イケダ',
	'ハシモト',
	'アベ',
	'イシカワ',
	'ヤマシタ',
	'ナカジマ',
	'イシイ',
	'オガワ',
	'マエダ',
	'オカダ',
	'ハセガワ',
	'フジタ',
	'ゴトウ',
	'コンドウ',
	'ムラカミ',
	'エンドウ',
	'アオキ',
	'サカモト',
	'フクダ',
	'オオタ',
	'ニシムラ',
	'フジイ',
	'オカモト',
	'フジワラ',
	'カネコ',
	'ミウラ',
	'ナカノ',
	'ナカガワ',
	'ハラダ',
];

// 性別 0->男 1->女
// 性別によって変わるものがあるのでこれについては mt_rand(0,1) で取得するべきである
// 加工しやすいように数字で与えるべきか
$seibetsu_list = ['男','女'];

// 名
$mei_list = [
	[
		'博一',
		'浩二',
		'哲也',
		'和仁',
		'歩',
		'仁',
		'健一',
		'智弘',
		'純一郎',
		'昭俊',
		'周作',
		'孝之',
		'和弘',
		'貴文',
		'信也',
		'雄介',
		'忠雄',
		'大吾',
		'博文',
		'恭二',
		'正嗣',
		'誠司',
		'時雄',
		'茂雄',
		'正一',
		'翔',
		'清太郎',
		'康信',
		'昭典',
		'真一',
	],
	[
		'佳代子',
		'律子',
		'蒔苗',
		'麻衣',
		'緑',
		'歩',
		'千佳',
		'ともみ',
		'さくら',
		'弘美',
		'梢',
		'加奈',
		'美穂',
		'澄江',
		'智子',
		'美鈴',
		'美紀',
		'聡美',
		'円',
		'美里',
		'薫',
		'梨穂子',
		'よしえ',
		'美樹',
		'由美子',
		'里奈',
		'里恵',
		'さおり',
	]
];

$mei_eng_list = [
	[
		'hiroichi',
		'kouji',
		'tetuya',
		'kazuhito',
		'ayumu',
		'hitoshi',
		'kennichi',
		'tomohiro',
		'junnichiro',
		'akitoshi',
		'shuusaku',
		'takayuki',
		'kazuhiro',
		'takahumi',
		'shinnya',
		'yuusuke',
		'tadao',
		'daigo',
		'hirohumi',
		'kyouji',
		'masatugu',
		'seiji',
		'tokio',
		'shigeo',
		'shouichi',
		'kakeru',
		'seitarou',
		'yasunobu',
		'akinori',
		'shinnichi',
	],
	[
		'kayoko',
		'rituko',
		'makanae',
		'mai',
		'midori',
		'ayumi',
		'chika',
		'tomomi',
		'sakura',
		'hiromi',
		'kozue',
		'kana',
		'miho',
		'sumie',
		'tomoko',
		'misuzu',
		'miki',
		'satomi',
		'madoka',
		'misato',
		'kaoru',
		'rihoko',
		'yoshie',
		'miki',
		'yumiko',
		'rina',
		'rie',
		'saori',
	]
];

$mei_kana_list_1 = [
	[
		'ひろいち',
		'こうじ',
		'てつや',
		'かずひと',
		'あゆむ',
		'ひとし',
		'けんいち',
		'ともひろ',
		'じゅんいちろう',
		'あきとし',
		'しゅうさく',
		'たかゆき',
		'かずひろ',
		'たかふみ',
		'しんや',
		'ゆうすけ',
		'ただお',
		'だいご',
		'ひろふみ',
		'きょうじ',
		'まさつぐ',
		'せいじ',
		'ときお',
		'しげお',
		'しょういち',
		'かける',
		'せいたろう',
		'やすのぶ',
		'あきのり',
		'しんいち',
	],
	[
		'かよこ',
		'りつこ',
		'まかなえ',
		'まい',
		'みどり',
		'あゆみ',
		'ちか',
		'ともみ',
		'さくら',
		'ひろみ',
		'こずえ',
		'かな',
		'みほ',
		'すみえ',
		'ともこ',
		'みすず',
		'みき',
		'さとみ',
		'まどか',
		'みさと',
		'かおる',
		'りほこ',
		'よしえ',
		'みき',
		'ゆみこ',
		'りな',
		'りえ',
		'さおり',
	]
];

$mei_kana_list_2 = [
	[
		'ヒロイチ',
		'コウジ',
		'テツヤ',
		'カズヒト',
		'アユム',
		'ヒトシ',
		'ケンイチ',
		'トモヒロ',
		'ジュンイチロウ',
		'アキトシ',
		'シュウサク',
		'タカユキ',
		'カズヒロ',
		'タカフミ',
		'シンヤ',
		'ユウスケ',
		'タダオ',
		'ダイゴ',
		'ヒロフミ',
		'キョウジ',
		'マサツグ',
		'セイジ',
		'トキオ',
		'シゲオ',
		'ショウイチ',
		'カケル',
		'セイタロウ',
		'ヤスノブ',
		'アキノリ',
		'シンイチ',
	],
	[
		'カヨコ',
		'リツコ',
		'マカナエ',
		'マイ',
		'ミドリ',
		'アユミ',
		'チカ',
		'トモミ',
		'サクラ',
		'ヒロミ',
		'コズエ',
		'カナ',
		'ミホ',
		'スミエ',
		'トモコ',
		'ミスズ',
		'ミキ',
		'サトミ',
		'マドカ',
		'ミサト',
		'カオル',
		'リホコ',
		'ヨシエ',
		'ミキ',
		'ユミコ',
		'リナ',
		'リエ',
		'サオリ',
	]
];


// メールアドレスの先頭部分
// @apteq.jp をつなげる
$mail_address_list = [
	'test',
	'abc',
	'dog',
	'cat',
	'bird',
	'rabbit',
	'tiger',
	'horse',
	'fox',
	'bear',
	'monkey',
	'sheep',
	'wolf',
	'deer',
	'zebra',
	'cow',
	'koala',
	'bat',
	'skunk',
	'elephant',
	'rat',
	'reindeer',
	'panda',
	'leopard',
	'pig',
	'mole',
	'goat'
];


function user_data(){
	global $sei_list,$seibetsu_list,$mei_list,$mail_address_list,$sei_eng_list,$mei_eng_list,$address_list;
	global $sei_kana_list_1,$sei_kana_list_2,$mei_kana_list_1,$mei_kana_list_2;

	// 姓
	// 姓は性別によって変わることはない
	$rand_sei = array_rand($sei_list);
	$select_sei = $sei_list[$rand_sei];
	$select_eng_sei = $sei_eng_list[$rand_sei];
	$select_sei_kana_1 = $sei_kana_list_1[$rand_sei];
	$select_sei_kana_2 = $sei_kana_list_2[$rand_sei];

	// 性別
	$select = mt_rand(0,1); // 性別によっていろいろと変わる
	$select_seibetsu = $select;

	// 名
	$rand_mei = array_rand($mei_list[$select]);
	$select_mei = $mei_list[$select][$rand_mei];
	$select_eng_mei = $mei_eng_list[$select][$rand_mei];
	$select_mei_kana_1 = $mei_kana_list_1[$select][$rand_mei];
	$select_mei_kana_2 = $mei_kana_list_2[$select][$rand_mei];

	// メールアドレス
	// ランダムで2回文字列をつなげてさらにランダムの数字をつける
	$select_mail = "";
	for($user_data_loop=0;$user_data_loop<2;$user_data_loop++){
		if($user_data_loop != 0){
			$select_mail .= "-";
		}
		$select_mail .= $mail_address_list[array_rand($mail_address_list)];
	}
	$select_mail .= sprintf('%04d',mt_rand(0,9999));
	$select_mail .= sprintf('%04d',mt_rand(0,9999));
	$select_mail .= "@example.com";

	// 誕生日
	$start_date = new DateTime();
	$start_date = $start_date->setDate($start_date->format('Y'),1,1)->modify("-50 year")->format("Y-m-d");
	$end_date = new DateTime();
	$end_date = $end_date->setDate($end_date->format('Y'),12,31)->modify("-18 year")->format("Y-m-d");

	$start = strtotime($start_date);
	$end = strtotime($end_date);
	$birthday = mt_rand($start,$end);
	$birthday = date('Y-m-d', $birthday);

	$address_data = $address_list[array_rand($address_list)];
	$address_1 = $address_data["name"];
	$address_2 = $address_data["address"];
	$post_code = $address_data["post_code"];

	$array = [
		'sei' => $select_sei,
		'seibetsu' => $select_seibetsu,
		'mei' => $select_mei,
		'mail' => $select_mail,
		'birthday' => $birthday,
		'eng_sei' => $select_eng_sei,
		'eng_mei' => $select_eng_mei,
		'sei_kana_1' => $select_sei_kana_1,
		'sei_kana_2' => $select_sei_kana_2,
		'mei_kana_1' => $select_mei_kana_1,
		'mei_kana_2' => $select_mei_kana_2,
		'address_1' => $address_1,
		'address_2' => $address_2,
		'post_code' => $post_code,
	];

	return $array;
}
