<?php
require_once '../../include/server_check.php';
require_once '../../include/functions.php';
require_once '../../include/db.php';
require_once '../../include/config.php';

$title = "テスト用";

$create_user_id = filter_input(INPUT_POST,"user");
$create_asa = filter_input(INPUT_POST,"asa");
$create_hiru = filter_input(INPUT_POST,"hiru");
$create_yoru = filter_input(INPUT_POST,"yoru");

$create_user_mail = "";

$options = "";
$error_text = "";
$create_list = "";
try {
	$pdo = DBopen();

	$select_sql = "SELECT * FROM user WHERE 1 ORDER BY user_id DESC";
	$select = $pdo->query($select_sql);
	while($row = $select->fetch()){
		$user_id = $row["user_id"];
		$mail = $row["mail"];

		if($user_id == $create_user_id){
			$create_user_mail = $mail;
		}

		$options .= "<option value=\"{$user_id}\">{$mail}</option>";
	}

	if(!empty($create_user_id)){
		// 記録を作成する
		$insert_sql = "INSERT INTO report (user_id, report1, report2, memo, created, created_date, created_time) VALUES (?,?,?,?,?,?,?)";
		$insert = $pdo->prepare($insert_sql);

		$max = max($create_asa,$create_hiru,$create_yoru);

		for($i=0;$i<=$max;$i++){
			$date = new DateTime();
			$date->modify("-7 days");
			$date->modify("+{$i} days");
			if($create_asa > $i){
				// 朝の記録を挿入する
				$date->setTime(4,0,0);
				$created = $date->format("Y-m-d H:i:s");
				$created_date = $date->format("Y-m-d");
				$created_time = $date->format("H:i:s");
				$report1 = rand(1,5);
				$report2 = rand(1,5);
				$memo = rand(0,1) ? "memo" : "";

				$insert->bindValue(1,$create_user_id,PDO::PARAM_STR);
				$insert->bindValue(2,$report1,PDO::PARAM_STR);
				$insert->bindValue(3,$report2,PDO::PARAM_STR);
				$insert->bindValue(4,$memo,PDO::PARAM_STR);
				$insert->bindValue(5,$created,PDO::PARAM_STR);
				$insert->bindValue(6,$created_date,PDO::PARAM_STR);
				$insert->bindValue(7,$created_time,PDO::PARAM_STR);
				$insert->execute();

				$create_list .= "{$created}<br>";
			}

			if($create_hiru > $i){
				// 昼の記録を挿入する
				$date->setTime(12,0,0);
				$created = $date->format("Y-m-d H:i:s");
				$created_date = $date->format("Y-m-d");
				$created_time = $date->format("H:i:s");
				$report1 = rand(1,5);
				$report2 = rand(1,5);
				$memo = rand(0,1) ? "memo" : "";

				$insert->bindValue(1,$create_user_id,PDO::PARAM_STR);
				$insert->bindValue(2,$report1,PDO::PARAM_STR);
				$insert->bindValue(3,$report2,PDO::PARAM_STR);
				$insert->bindValue(4,$memo,PDO::PARAM_STR);
				$insert->bindValue(5,$created,PDO::PARAM_STR);
				$insert->bindValue(6,$created_date,PDO::PARAM_STR);
				$insert->bindValue(7,$created_time,PDO::PARAM_STR);
				$insert->execute();

				$create_list .= "{$created}<br>";
			}

			if($create_yoru > $i){
				// 夜の記録を挿入する
				$date->setTime(21,0,0);
				$created = $date->format("Y-m-d H:i:s");
				$created_date = $date->format("Y-m-d");
				$created_time = $date->format("H:i:s");
				$report1 = rand(1,5);
				$report2 = rand(1,5);
				$memo = rand(0,1) ? "memo" : "";

				$insert->bindValue(1,$create_user_id,PDO::PARAM_STR);
				$insert->bindValue(2,$report1,PDO::PARAM_STR);
				$insert->bindValue(3,$report2,PDO::PARAM_STR);
				$insert->bindValue(4,$memo,PDO::PARAM_STR);
				$insert->bindValue(5,$created,PDO::PARAM_STR);
				$insert->bindValue(6,$created_date,PDO::PARAM_STR);
				$insert->bindValue(7,$created_time,PDO::PARAM_STR);
				$insert->execute();

				$create_list .= "{$created}<br>";
			}
		}
	}
} catch(Exception $e){
	$error = $e->getMessage();
	$error_text = $error;
}

$count_options = "";
for($i=0;$i<7;$i++){
	$count_options .= "<option value=\"{$i}\">{$i}</option>";
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<title><?=$title?></title>
</head>
<body>
	<form method="post">
		ユーザー
		<select name="user">
			<?=$options?>
		</select>
		<br>
		朝
		<select name="asa">
			<?=$count_options?>
		</select>
		<br>
		昼
		<select name="hiru">
			<?=$count_options?>
		</select>
		<br>
		夜
		<select name="yoru">
			<?=$count_options?>
		</select>
		<p></p>
		<input type="submit">
	</form>
	<p><?=$error_text?></p>
	<p>CREATED</p>
	<p>ユーザー：<?=$create_user_id?>, <?=$create_user_mail?></p>
	<p><?=$create_list?></p>
</body>
</html>
