<?php
require_once '../../include/server_check.php';
require_once '../../include/functions.php';
require_once '../../include/db.php';
require_once '../../include/config.php';

$error_text = "";

$title = "テスト用";

$id = filter_input(INPUT_POST,"id");
$password = filter_input(INPUT_POST,"password");
$shop = filter_input(INPUT_POST,"shop");

if(!empty($id)){
	try {
		$pdo = DBopen();

		/*
		if(!empty($password)){
			$hash = password_hash($password, PASSWORD_DEFAULT);
		} else {
			// password
			$password = "password";
			$hash = "$2y$10$4vjSmBVV7ekNfaG1eyc9g.H3MjWwoc7s1QQgNBNTYZxvMny.yDRLm";
		}
		*/
		$password = RandomPass();
		$hash = password_hash($password, PASSWORD_DEFAULT);

		$insert_sql = "INSERT INTO master (id,password,shop) VALUES (?,?,?)";
		$insert = $pdo->prepare($insert_sql);
		$insert->bindValue(1,$id,PDO::PARAM_STR);
		$insert->bindValue(2,$hash,PDO::PARAM_STR);
		$insert->bindValue(3,$shop,PDO::PARAM_STR);
		$insert->execute();

	} catch(Exception $e){
		$error = $e->getMessage();
		$error_text = $error;
	}
}

$options = "";
foreach(shop_list as $value){
	$options .=<<<EOD
	<option value="{$value}">{$value}</option>
	EOD;
}

// change
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<title><?=$title?></title>
</head>
<body>
	<form method="post">
		<input type="text" name="id" placeholder="id" required><br>
		<select name="shop">
			<?=$options?>
		</select>
		<p></p>
		<input type="submit">
	</form>
	<p><?=$error_text?></p>
	<p>ID: <?=$id?></p>
	<p>PASS: <?=$password?></p>
	<p>SHOP: <?=$shop?></p>
</body>
</html>
