<?php
require_once '../../include/server_check.php';
require_once '../../include/functions.php';
require_once '../../include/db.php';
require_once '../../include/config.php';
require_once 'user_data.php';
require_once '../../include/calc.php';

$error_text = "";

$title = "テスト用";

$create_id = filter_input(INPUT_POST,"id");
$type = filter_input(INPUT_POST,"type");
$shop = filter_input(INPUT_POST,"shop");

$create_list = "";

if(!empty($create_id)){
	try {
		$pdo = DBopen();

		$insert_sql = "INSERT INTO user (password, mail, name1, name2, kana_name1, kana_name2, gender, pair, shop, ring_type, ring_size, ring_width, ring_thickness, remarks, fixed_date, fixed_ring_type, fixed_ring_size, fixed_ring_width,fixed_ring_thickness, handedness, joint, working, frequency, alcohol, taste, created, updated) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$insert = $pdo->prepare($insert_sql);

		// password
		$password = "password";
		$hash = "$2y$10$4vjSmBVV7ekNfaG1eyc9g.H3MjWwoc7s1QQgNBNTYZxvMny.yDRLm";

		$date = new DateTime();
		$created = $date->format("Y-m-d H:i:s");
		$updated = $created;
		$fixed_date = $created;

		$insert_report_sql = "INSERT INTO report (user_id, report1, report2, memo, created, created_date, created_time) VALUES (?,?,?,?,?,?,?)";
		$insert_report = $pdo->prepare($insert_report_sql);

		for($i=0;$i<$create_id;$i++){
			$pair_create_flag = true;
			$id_list = [];

			if($pair_create_flag){
				// ペア番号の取得
				$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY pair DESC LIMIT 1";
				// ソートできない問題対策, 数値に変換してソート
				//$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY cast(pair as SIGNED) DESC LIMIT 1";
				$select_pair_num = $pdo->query($select_pair_num_sql);
				if($row = $select_pair_num->fetch()){
					// 存在している
					$pair_num = $row["pair"];
				} else {
					// 存在していない
					$pair_num = 0;
				}
				// 新しいペア番号
				$pair_num += 1;

				$create_list .= "--- PAIR ---<br>";
			} else {
				// ペアを作らない
				$pair_num = "";

				$create_list .= "--- SOLO ---<br>";
			}

			$user_data = user_data();

			$user_seibetsu = $user_data["seibetsu"] + 1; // return 0,1 DB 1,2
			$user_sei = $user_data["sei"];
			$user_mei = $user_data["mei"];
			$user_mail = $user_data["mail"];
			$user_sei_kana_1 = $user_data["sei_kana_1"];
			$user_mei_kana_1 = $user_data["mei_kana_1"];

			$ring_type = mt_rand(1,count(ring_type_list));
			$ring_size = mt_rand(1,30);
			$ring_width = mt_rand(1,10);
			$ring_thickness = mt_rand(1,10);
			$remarks = "";

			$fixed_ring_type = mt_rand(1,count(ring_type_list));
			$fixed_ring_size = $ring_size + mt_rand(0,4) - 2;
			$fixed_ring_width = $ring_width + mt_rand(0,4) - 2;
			$fixed_ring_thickness = $ring_thickness + mt_rand(0,4) - 2;

			$handedness = mt_rand(1,count(hand_list));
			$joint = mt_rand(1,count(joint_list));
			$working = mt_rand(1,count(working_list));
			$frequency = mt_rand(1,count(frequency_list));
			$alcohol = mt_rand(1,count(alcohol_list));
			$taste = mt_rand(1,count(taste_list));

			$insert->bindValue(1,$hash,PDO::PARAM_STR);
			$insert->bindValue(2,$user_mail,PDO::PARAM_STR);
			$insert->bindValue(3,$user_sei,PDO::PARAM_STR);
			$insert->bindValue(4,$user_mei,PDO::PARAM_STR);
			$insert->bindValue(5,$user_sei_kana_1,PDO::PARAM_STR);
			$insert->bindValue(6,$user_mei_kana_1,PDO::PARAM_STR);
			$insert->bindValue(7,$user_seibetsu,PDO::PARAM_STR);
			$insert->bindValue(8,$pair_num,PDO::PARAM_STR);
			$insert->bindValue(9,$shop,PDO::PARAM_STR);
			$insert->bindValue(10,$ring_type,PDO::PARAM_STR);
			$insert->bindValue(11,$ring_size,PDO::PARAM_STR);
			$insert->bindValue(12,$ring_width,PDO::PARAM_STR);
			$insert->bindValue(13,$ring_thickness,PDO::PARAM_STR);
			$insert->bindValue(14,$remarks,PDO::PARAM_STR);
			$insert->bindValue(15,$fixed_date,PDO::PARAM_STR);
			$insert->bindValue(16,$fixed_ring_type,PDO::PARAM_STR);
			$insert->bindValue(17,$fixed_ring_size,PDO::PARAM_STR);
			$insert->bindValue(18,$fixed_ring_width,PDO::PARAM_STR);
			$insert->bindValue(19,$fixed_ring_thickness,PDO::PARAM_STR);
			$insert->bindValue(20,$handedness,PDO::PARAM_STR);
			$insert->bindValue(21,$joint,PDO::PARAM_STR);
			$insert->bindValue(22,$working,PDO::PARAM_STR);
			$insert->bindValue(23,$frequency,PDO::PARAM_STR);
			$insert->bindValue(24,$alcohol,PDO::PARAM_STR);
			$insert->bindValue(25,$taste,PDO::PARAM_STR);
			$insert->bindValue(26,$created,PDO::PARAM_STR);
			$insert->bindValue(27,$updated,PDO::PARAM_STR);
			$insert->execute();

			$user_id = $pdo->lastInsertId();
			$id_list[] = $user_id;

			$create_list .= "ID:{$user_id}, MAIL:{$user_mail}<br>";

			if($pair_create_flag){
				$user_data = user_data();

				$user_seibetsu = $user_data["seibetsu"] + 1; // return 0,1 DB 1,2
				$user_sei = $user_data["sei"];
				$user_mei = $user_data["mei"];
				$user_mail = $user_data["mail"];
				$user_sei_kana_1 = $user_data["sei_kana_1"];
				$user_mei_kana_1 = $user_data["mei_kana_1"];

				$ring_type = mt_rand(1,count(ring_type_list));
				$ring_size = mt_rand(1,30);
				$ring_width = mt_rand(1,10);
				$ring_thickness = mt_rand(1,10);
				$remarks = "";

				$fixed_ring_type = mt_rand(1,count(ring_type_list));
				$fixed_ring_size = $ring_size + mt_rand(0,4) - 2;
				$fixed_ring_width = $ring_width + mt_rand(0,4) - 2;
				$fixed_ring_thickness = $ring_thickness + mt_rand(0,4) - 2;

				$handedness = mt_rand(1,count(hand_list));
				$joint = mt_rand(1,count(joint_list));
				$working = mt_rand(1,count(working_list));
				$frequency = mt_rand(1,count(frequency_list));
				$alcohol = mt_rand(1,count(alcohol_list));
				$taste = mt_rand(1,count(taste_list));

				$insert->bindValue(1,$hash,PDO::PARAM_STR);
				$insert->bindValue(2,$user_mail,PDO::PARAM_STR);
				$insert->bindValue(3,$user_sei,PDO::PARAM_STR);
				$insert->bindValue(4,$user_mei,PDO::PARAM_STR);
				$insert->bindValue(5,$user_sei_kana_1,PDO::PARAM_STR);
				$insert->bindValue(6,$user_mei_kana_1,PDO::PARAM_STR);
				$insert->bindValue(7,$user_seibetsu,PDO::PARAM_STR);
				$insert->bindValue(8,$pair_num,PDO::PARAM_STR);
				$insert->bindValue(9,$shop,PDO::PARAM_STR);
				$insert->bindValue(10,$ring_type,PDO::PARAM_STR);
				$insert->bindValue(11,$ring_size,PDO::PARAM_STR);
				$insert->bindValue(12,$ring_width,PDO::PARAM_STR);
				$insert->bindValue(13,$ring_thickness,PDO::PARAM_STR);
				$insert->bindValue(14,$remarks,PDO::PARAM_STR);
				$insert->bindValue(15,$fixed_date,PDO::PARAM_STR);
				$insert->bindValue(16,$fixed_ring_type,PDO::PARAM_STR);
				$insert->bindValue(17,$fixed_ring_size,PDO::PARAM_STR);
				$insert->bindValue(18,$fixed_ring_width,PDO::PARAM_STR);
				$insert->bindValue(19,$fixed_ring_thickness,PDO::PARAM_STR);
				$insert->bindValue(20,$handedness,PDO::PARAM_STR);
				$insert->bindValue(21,$joint,PDO::PARAM_STR);
				$insert->bindValue(22,$working,PDO::PARAM_STR);
				$insert->bindValue(23,$frequency,PDO::PARAM_STR);
				$insert->bindValue(24,$alcohol,PDO::PARAM_STR);
				$insert->bindValue(25,$taste,PDO::PARAM_STR);
				$insert->bindValue(26,$created,PDO::PARAM_STR);
				$insert->bindValue(27,$updated,PDO::PARAM_STR);
				$insert->execute();

				$pair_user_id = $pdo->lastInsertId();
				$id_list[] = $pair_user_id;

				$create_list .= "ID:{$pair_user_id}, MAIL:{$user_mail}<br>";
			}

			// 記録をいれる
			foreach($id_list as $user_id){
				$report_max = mt_rand(3,5);
				$report_min = mt_rand(1,3);
				for($j=0;$j<=7;$j++){
					$date = new DateTime();
					$date->modify("-7 days");
					$date->modify("+{$j} days");

					// 朝の記録を挿入する
					$hour = mt_rand(4,10);
					$minute = mt_rand(0,59);
					$second = mt_rand(0,59);
					$date->setTime($hour,$minute,$second);
					$report_created = $date->format("Y-m-d H:i:s");
					$report_created_date = $date->format("Y-m-d");
					$report_created_time = $date->format("H:i:s");
					$report1 = mt_rand($report_min,$report_max);
					$report2 = mt_rand($report_min,$report_max);
					$memo = mt_rand(0,1) ? "memo" : "";

					$insert_report->bindValue(1,$user_id,PDO::PARAM_STR);
					$insert_report->bindValue(2,$report1,PDO::PARAM_STR);
					$insert_report->bindValue(3,$report2,PDO::PARAM_STR);
					$insert_report->bindValue(4,$memo,PDO::PARAM_STR);
					$insert_report->bindValue(5,$report_created,PDO::PARAM_STR);
					$insert_report->bindValue(6,$report_created_date,PDO::PARAM_STR);
					$insert_report->bindValue(7,$report_created_time,PDO::PARAM_STR);
					$insert_report->execute();

					// 昼の記録を挿入する
					$hour = mt_rand(11,16);
					$minute = mt_rand(0,59);
					$second = mt_rand(0,59);
					$date->setTime($hour,$minute,$second);
					$report_created = $date->format("Y-m-d H:i:s");
					$report_created_date = $date->format("Y-m-d");
					$report_created_time = $date->format("H:i:s");
					$report1 = mt_rand($report_min,$report_max);
					$report2 = mt_rand($report_min,$report_max);
					$memo = mt_rand(0,1) ? "memo" : "";

					$insert_report->bindValue(1,$user_id,PDO::PARAM_STR);
					$insert_report->bindValue(2,$report1,PDO::PARAM_STR);
					$insert_report->bindValue(3,$report2,PDO::PARAM_STR);
					$insert_report->bindValue(4,$memo,PDO::PARAM_STR);
					$insert_report->bindValue(5,$report_created,PDO::PARAM_STR);
					$insert_report->bindValue(6,$report_created_date,PDO::PARAM_STR);
					$insert_report->bindValue(7,$report_created_time,PDO::PARAM_STR);
					$insert_report->execute();

					// 夜の記録を挿入する
					$hour = mt_rand(17,23);
					$minute = mt_rand(0,59);
					$second = mt_rand(0,59);
					$date->setTime($hour,$minute,$second);
					$report_created = $date->format("Y-m-d H:i:s");
					$report_created_date = $date->format("Y-m-d");
					$report_created_time = $date->format("H:i:s");
					$report1 = mt_rand($report_min,$report_max);
					$report2 = mt_rand($report_min,$report_max);
					$memo = mt_rand(0,1) ? "memo" : "";

					$insert_report->bindValue(1,$user_id,PDO::PARAM_STR);
					$insert_report->bindValue(2,$report1,PDO::PARAM_STR);
					$insert_report->bindValue(3,$report2,PDO::PARAM_STR);
					$insert_report->bindValue(4,$memo,PDO::PARAM_STR);
					$insert_report->bindValue(5,$report_created,PDO::PARAM_STR);
					$insert_report->bindValue(6,$report_created_date,PDO::PARAM_STR);
					$insert_report->bindValue(7,$report_created_time,PDO::PARAM_STR);
					$insert_report->execute();
				}
			}
			// データを入れきったら計算する
			foreach($id_list as $user_id){
				diagnosis($pdo,$user_id);
			}
		}
	} catch(Exception $e){
		$error = $e->getMessage();
		$error_text = $error;
	}
}

$options = "";
foreach(shop_list as $value){
	if($value === "マスター"){
		continue;
	}
	if($value === $shop){
		$selected = " selected";
	} else {
		$selected = "";
	}
	$options .=<<<EOD
	<option value="{$value}"{$selected}>{$value}</option>
	EOD;
}

// change
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<title><?=$title?></title>
</head>
<body>
	<form method="post">
		<input type="number" name="id" placeholder="id数" value="<?=$create_id?>" required><br>
		<br>
		<select name="shop">
			<?=$options?>
		</select>
		<p></p>
		<input type="submit">
	</form>
	<p><?=$error_text?></p>
	<p>CREATED</p>
	<p><?=$create_list?></p>
</body>
</html>
