<?php
require_once '../../include/server_check.php';
require_once '../../include/functions.php';
require_once '../../include/db.php';
require_once '../../include/config.php';
require_once 'user_data.php';

$error_text = "";

$title = "テスト用";

$create_id = filter_input(INPUT_POST,"id");
$type = filter_input(INPUT_POST,"type");
$shop = filter_input(INPUT_POST,"shop");

$create_list = "";

if(!empty($create_id)){
	try {
		$pdo = DBopen();

		$insert_sql = "INSERT INTO user (password, mail, name1, name2, kana_name1, kana_name2, gender, pair, shop, ring_type, ring_size, ring_width, ring_thickness, remarks, created, updated) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$insert = $pdo->prepare($insert_sql);

		// password
		$password = "password";
		$hash = "$2y$10$4vjSmBVV7ekNfaG1eyc9g.H3MjWwoc7s1QQgNBNTYZxvMny.yDRLm";

		$date = new DateTime();
		$created = $date->format("Y-m-d H:i:s");
		$updated = $created;

		for($i=0;$i<$create_id;$i++){
			if($type === "1"){
				// 単独
				$pair_create_flag = false;
			} else if($type === "3"){
				// ランダム
				if(rand(0,1)){
					$pair_create_flag = true;
				} else {
					$pair_create_flag = false;
				}
			} else {
				$pair_create_flag = true;
			}

			if($pair_create_flag){
				// ペア番号の取得
				$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY pair DESC LIMIT 1";
				// ソートできない問題対策, 数値に変換してソート
				//$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY cast(pair as SIGNED) DESC LIMIT 1";
				$select_pair_num = $pdo->query($select_pair_num_sql);
				if($row = $select_pair_num->fetch()){
					// 存在している
					$pair_num = $row["pair"];
				} else {
					// 存在していない
					$pair_num = 0;
				}
				// 新しいペア番号
				$pair_num += 1;

				$create_list .= "--- PAIR ---<br>";
			} else {
				// ペアを作らない
				$pair_num = "";

				$create_list .= "--- SOLO ---<br>";
			}

			$user_data = user_data();

			$user_seibetsu = $user_data["seibetsu"] + 1; // return 0,1 DB 1,2
			$user_sei = $user_data["sei"];
			$user_mei = $user_data["mei"];
			$user_mail = $user_data["mail"];
			$user_sei_kana_1 = $user_data["sei_kana_1"];
			$user_mei_kana_1 = $user_data["mei_kana_1"];

			$ring_type = rand(1,3);
			$ring_size = rand(1,15);
			$ring_width = rand(1,10);
			$ring_thickness = rand(1,10);
			$remarks = "";

			$insert->bindValue(1,$hash,PDO::PARAM_STR);
			$insert->bindValue(2,$user_mail,PDO::PARAM_STR);
			$insert->bindValue(3,$user_sei,PDO::PARAM_STR);
			$insert->bindValue(4,$user_mei,PDO::PARAM_STR);
			$insert->bindValue(5,$user_sei_kana_1,PDO::PARAM_STR);
			$insert->bindValue(6,$user_mei_kana_1,PDO::PARAM_STR);
			$insert->bindValue(7,$user_seibetsu,PDO::PARAM_STR);
			$insert->bindValue(8,$pair_num,PDO::PARAM_STR);
			$insert->bindValue(9,$shop,PDO::PARAM_STR);
			$insert->bindValue(10,$ring_type,PDO::PARAM_STR);
			$insert->bindValue(11,$ring_size,PDO::PARAM_STR);
			$insert->bindValue(12,$ring_width,PDO::PARAM_STR);
			$insert->bindValue(13,$ring_thickness,PDO::PARAM_STR);
			$insert->bindValue(14,$remarks,PDO::PARAM_STR);
			$insert->bindValue(15,$created,PDO::PARAM_STR);
			$insert->bindValue(16,$updated,PDO::PARAM_STR);
			$insert->execute();

			$create_list .= "{$user_mail}<br>";

			if($pair_create_flag){
				$user_data = user_data();

				$user_seibetsu = $user_data["seibetsu"] + 1; // return 0,1 DB 1,2
				$user_sei = $user_data["sei"];
				$user_mei = $user_data["mei"];
				$user_mail = $user_data["mail"];
				$user_sei_kana_1 = $user_data["sei_kana_1"];
				$user_mei_kana_1 = $user_data["mei_kana_1"];

				$ring_type = rand(1,3);
				$ring_size = rand(1,15);
				$ring_width = rand(1,10);
				$ring_thickness = rand(1,10);
				$remarks = "";

				$insert->bindValue(1,$hash,PDO::PARAM_STR);
				$insert->bindValue(2,$user_mail,PDO::PARAM_STR);
				$insert->bindValue(3,$user_sei,PDO::PARAM_STR);
				$insert->bindValue(4,$user_mei,PDO::PARAM_STR);
				$insert->bindValue(5,$user_sei_kana_1,PDO::PARAM_STR);
				$insert->bindValue(6,$user_mei_kana_1,PDO::PARAM_STR);
				$insert->bindValue(7,$user_seibetsu,PDO::PARAM_STR);
				$insert->bindValue(8,$pair_num,PDO::PARAM_STR);
				$insert->bindValue(9,$shop,PDO::PARAM_STR);
				$insert->bindValue(10,$ring_type,PDO::PARAM_STR);
				$insert->bindValue(11,$ring_size,PDO::PARAM_STR);
				$insert->bindValue(12,$ring_width,PDO::PARAM_STR);
				$insert->bindValue(13,$ring_thickness,PDO::PARAM_STR);
				$insert->bindValue(14,$remarks,PDO::PARAM_STR);
				$insert->bindValue(15,$created,PDO::PARAM_STR);
				$insert->bindValue(16,$updated,PDO::PARAM_STR);
				$insert->execute();

				$create_list .= "{$user_mail}<br>";
			}
		}

	} catch(Exception $e){
		$error = $e->getMessage();
		$error_text = $error;
	}
}

$options = "";
foreach(shop_list as $value){
	if($value === "マスター"){
		continue;
	}
	if($value === $shop){
		$selected = " selected";
	} else {
		$selected = "";
	}
	$options .=<<<EOD
	<option value="{$value}"{$selected}>{$value}</option>
	EOD;
}

// change
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<title><?=$title?></title>
</head>
<body>
	<form method="post">
		<input type="number" name="id" placeholder="id数" value="<?=$create_id?>" required><br>
		<select name="type">
			<option value="1"<?= $type === "1" ? " selected" : ""?>>単体</option>
			<option value="2"<?= $type === "2" ? " selected" : ""?>>ペア</option>
			<option value="3"<?= $type === "3" ? " selected" : ""?>>ランダム</option>
		</select>
		<br>
		<select name="shop">
			<?=$options?>
		</select>
		<p></p>
		<input type="submit">
	</form>
	<p><?=$error_text?></p>
	<p>CREATED</p>
	<p><?=$create_list?></p>
</body>
</html>
