<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー詳細";

$user_id = filter_input(INPUT_POST,"user_id");
$name1 = filter_input(INPUT_POST,"name1");
$name2 = filter_input(INPUT_POST,"name2");
$kana1 = filter_input(INPUT_POST,"kana1");
$kana2 = filter_input(INPUT_POST,"kana2");
$gender = filter_input(INPUT_POST,"gender");
$mail = filter_input(INPUT_POST,"mail");
$ring_type = filter_input(INPUT_POST,"ring_type");
$ring_size = filter_input(INPUT_POST,"ring_size");
$ring_width = filter_input(INPUT_POST,"ring_width");
$ring_thickness = filter_input(INPUT_POST,"ring_thickness");
$remarks = filter_input(INPUT_POST,"remarks");

$posted_log = "user_id -> {$user_id} | name1 -> {$name1} | name2 -> {$name2} | kana1 -> {$kana1} | kana2 -> {$kana2} | gender -> {$gender} | mail -> {$mail} | ring_type -> {$ring_type} | ring_size -> {$ring_size} | ring_width -> {$ring_width} | ring_thickness -> {$ring_thickness}";

if(empty($user_id) || empty($name1) || empty($name2) || empty($gender) || empty($mail) || empty($ring_type) || empty($ring_size) || empty($ring_width) || empty($ring_thickness)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	$update_sql = "UPDATE user SET mail = ?, name1 = ?, name2 = ?, kana_name1 = ?, kana_name2 = ?, gender = ?, ring_type = ?, ring_size = ?, ring_width = ?, ring_thickness = ?, remarks = ?, updated = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$date = new DateTime();
	$updated = $date->format("Y-m-d H:i:s");

	$update->bindValue(1,$mail,PDO::PARAM_STR);
	$update->bindValue(2,$name1,PDO::PARAM_STR);
	$update->bindValue(3,$name2,PDO::PARAM_STR);
	$update->bindValue(4,$kana1,PDO::PARAM_STR);
	$update->bindValue(5,$kana2,PDO::PARAM_STR);
	$update->bindValue(6,$gender,PDO::PARAM_STR);
	$update->bindValue(7,$ring_type,PDO::PARAM_STR);
	$update->bindValue(8,$ring_size,PDO::PARAM_STR);
	$update->bindValue(9,$ring_width,PDO::PARAM_STR);
	$update->bindValue(10,$ring_thickness,PDO::PARAM_STR);
	$update->bindValue(11,$remarks,PDO::PARAM_STR);
	$update->bindValue(12,$updated,PDO::PARAM_STR);
	$update->bindValue(13,$user_id,PDO::PARAM_STR);
	$update->execute();

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["details"]["action"] = "ユーザー情報を更新しました。";

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="details.php" name="f">
		<input type="hidden" id="user_id" name="user_id" value="<?=$user_id?>">
	</form>
</body>
</html>
