<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';

$user_id = filter_input(INPUT_POST,"user_id");
$ring_type = filter_input(INPUT_POST,"ring_type");
$ring_size = filter_input(INPUT_POST,"ring_size");
$ring_width = filter_input(INPUT_POST,"ring_width");
$ring_thickness = filter_input(INPUT_POST,"ring_thickness");

$posted_log = "user_id -> {$user_id} | ring_type -> {$ring_type} | ring_size -> {$ring_size} | ring_width -> {$ring_width} | ring_thickness -> {$ring_thickness}";

if(empty($user_id) || empty($ring_type) || empty($ring_size) || empty($ring_width) || empty($ring_thickness)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	$update_sql = "UPDATE user SET fixed_date = ?, fixed_ring_type = ?, fixed_ring_size = ?, fixed_ring_width = ?, fixed_ring_thickness = ?, updated = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$date = new DateTime();
	$updated = $date->format("Y-m-d H:i:s");

	$update->bindValue(1,$updated,PDO::PARAM_STR);
	$update->bindValue(2,$ring_type,PDO::PARAM_STR);
	$update->bindValue(3,$ring_size,PDO::PARAM_STR);
	$update->bindValue(4,$ring_width,PDO::PARAM_STR);
	$update->bindValue(5,$ring_thickness,PDO::PARAM_STR);
	$update->bindValue(6,$updated,PDO::PARAM_STR);
	$update->bindValue(7,$user_id,PDO::PARAM_STR);
	$update->execute();

	// 結果を計算してユーザーのタイプを確定する
	require_once '../include/calc.php';
	diagnosis($pdo,$user_id);

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["details"]["action"] = "指輪を確定しました。";

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="details.php" name="f">
		<input type="hidden" id="user_id" name="user_id" value="<?=$user_id?>">
	</form>
</body>
</html>
