<?php
// 指輪の確定

// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー詳細";
$date = new DateTime();
$date = $date->format("YmdHis");

$user_id = filter_input(INPUT_POST,"user_id");
if(empty($user_id)){
	require_once './error.php';
	exit;
}

$person_log = "user_id -> {$user_id}";

try {
	$pdo = DBopen();

	$select_sql = "SELECT * FROM user WHERE user_id = ?";
	$select = $pdo->prepare($select_sql);
	$select->bindValue(1,$user_id,PDO::PARAM_STR);
	$select->execute();
	if($row = $select->fetch()){
		$name1 = $row["name1"];
		$name2 = $row["name2"];
		$kana1 = $row["kana_name1"];
		$kana2 = $row["kana_name2"];
		$mail = $row["mail"];
		$gender = $row["gender"];
		$pair = $row["pair"];
		$shop = $row["shop"];
		$ring_type = $row["ring_type"];
		$ring_size = $row["ring_size"];
		$ring_width = $row["ring_width"];
		$ring_thickness = $row["ring_thickness"];
		$remarks = $row["remarks"];

		// 確定後
		$fixed_date = $row["fixed_date"];
		$fixed_ring_size = $row["fixed_ring_size"];
		$fixed_ring_width = $row["fixed_ring_width"];
		$fixed_ring_thickness = $row["fixed_ring_thickness"];
		$user_type1 = $row["user_type1"];
		$user_type2 = $row["user_type2"];

		$created = $row["created"];
		$updated = $row["updated"];

		$created = new DateTime($created);
		$created = $created->format("Y年n月j日");
		$updated = new DateTime($updated);
		$updated = $updated->format("Y年n月j日 G:i:s");

		$ring_type_options = "";
		$count = 0;
		foreach(ring_type_list as $value){
			$count++;
			if($ring_type == $count){
				$selected = " selected";
			} else {
				$selected = "";
			}
			$ring_type_options .= "<option value=\"{$count}\"{$selected}>{$value}</option>";
		}

		$ring_type = ring_type_list[$ring_type - 1];

		$gender = $gender == "1" ? "男性" : "女性";

	} else {
		throw new RuntimeException("対象が存在しない");
	}

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$person_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}



?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<link rel="apple-touch-icon" href="../img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="../js/script.js?v=<?=$date?>"></script>
<link href="../css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
const text_list = [
	"ring_size",
	"ring_width",
	"ring_thickness",
];
const error_list = [
	"ring_size_error", // ring_size
	"ring_width_error", // ring_width
	"ring_thickness_error", // ring_thickness
];
function update(){
	let flag = check();
	if(flag){
		create_form.submit();
	}
}
function check(){
	let flag = true;
	let focus_elm = "";

	let error_list_length = error_list.length;
	for(let i=0;i<error_list_length;i++){
		let elm_id = error_list[i];
		let error_elm = document.getElementById(elm_id);
		error_elm.style.display = "none";
	}

	let text_list_length = text_list.length;
	for(let i=0;i<text_list_length;i++){
		let elm_id = text_list[i];
		let text_input_elm = document.getElementById(elm_id);
		let value = text_input_elm.value;
		if(value == ""){
			flag = false;
			let error_elm_id = error_list[i];
			let error_elm = document.getElementById(error_elm_id);
			error_elm.style.display = "block";
			if(focus_elm === ""){
				focus_elm = text_input_elm;
			}
		} else if(elm_id == "mail"){
			// 空ではなくメールアドレスの時
			let mail_check_result_elm = document.getElementById("mail_check_result");
			let mail_check_result = mail_check_result_elm.value;
			if(mail_check_result != 1){
				// メールアドレスの形式が間違っている, すでに登録済みである
				flag = false;
				if(focus_elm === ""){
					focus_elm = text_input_elm;
				}
			}
		}
	}

	if(focus_elm !== ""){
		focus_elm.focus();
	}
	return flag;
}

function check_mail(e,p){
	let value = e.value;
	let flag;
	let pattern = /^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]+.[A-Za-z0-9]+$/;
	let pair = "";

	if(p){
		// pairのチェックである
		pair = "pair_";
	}

	let mail_check_error_elm = document.getElementById(pair + "mail_check_error");
	mail_check_error_elm.style.display = "none";

	let mail_exist_error_elm = document.getElementById(pair + "mail_exist_error");
	mail_exist_error_elm.style.display = "none";

	let mail_check_result_elm = document.getElementById(pair + "mail_check_result");
	mail_check_result_elm.value = "";

	if(pattern.test(value)){
		$.ajax({
			url : "./request/check_edit_mail.php",
			type : "POST",
			dataType:"text",
			data : {'user_id':'<?=$user_id?>','mail':value},
			//timeout:10000,
		}).done(function(data){
			console.log(data);
			if(data){
				// 存在しない
				flag = 1;
			} else {
				// 存在する
				flag = 0;
				mail_exist_error_elm.style.display = "block";
			}
			mail_check_result_elm.value = flag;
		}).fail(function(XMLHttpRequest, textStatus, errorThrown) {
			// 失敗時の処理
			flag = 0;
			return flag;
		})
	} else {
		flag = 0;
		mail_check_error_elm.style.display = "block";
		mail_check_result_elm.value = flag;
	}
}
function select_person(e){
	let post_data = {
		"url":"details.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="main">
		<div class="details_flex_box">
			<span class="link_text" onclick="select_person('<?=$user_id?>')">戻る</span>
			<span class="">更新日：<?=$updated?></span>
		</div>
		<div class="content_box">
			<form id="create_form" name="create_form" method="post" action="determine_save.php" autocomplete="off">
				<table class="create_new_account_table">
					<tr>
						<td class="create_table_head" colspan="4">ユーザー情報</td>
					</tr>
					<tr>
						<td class="account_table_item">名前</td>
						<td class="account_table_content" colspan="3"><span class="display_user_name"><?=$name1?></span><span class="display_user_name"><?=$name2?></span></td>
					</tr>
					<!--
					<tr>
						<td class="account_table_item">かな</td>
						<td class="account_table_content"><span class="display_user_name"><?=$kana1?></span><span class="display_user_name"><?=$kana2?></span></td>
					</tr>
					-->
					<tr>
						<td class="account_table_item">性別</td>
						<td class="account_table_content" colspan="3"><?=$gender?></td>
					</tr>
					<tr>
						<td class="account_table_item">メールアドレス</td>
						<td class="account_table_content" colspan="3"><?=$mail?></td>
					</tr>
					<tr>
						<td class="account_table_item">作成日</td>
						<td class="account_table_content" colspan="3"><?=$created?></td>
					</tr>
					<tr>
						<td class="account_table_item">対応店舗</td>
						<td class="account_table_content" colspan="3"><?=$shop?></td>
					</tr>
					<tr>
						<td class="create_table_head" colspan="4">指輪の確定</td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の形状</td>
						<td class="account_table_content">
							<?= $ring_type?>
						</td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content">
							<select id="ring_type" name="ring_type" required>
								<?= $ring_type_options ?>
							</select>
						</td>
					</tr>
					<tr>
						<td class="account_table_item">指輪のサイズ</td>
						<td class="account_table_content">
							<?=$ring_size?><?=ring_size_unit?>
						</td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content">
							<input type="number" id="ring_size" name="ring_size" class="input_num" min="0" step="0.1" value="<?=$ring_size?>" required><?=ring_size_unit?>
							<div id="ring_size_error" class="error_text">入力してください。</div>
						</td>
					</tr>
					<tr>
						<td class="account_table_item">幅</td>
						<td class="account_table_content">
							<?=$ring_width?><?=ring_width_unit?>
						</td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content">
							<input type="number" id="ring_width" name="ring_width" class="input_num" min="0" step="0.1" value="<?=$ring_width?>" required><?=ring_width_unit?>
							<div id="ring_width_error" class="error_text">入力してください。</div>
						</td>
					</tr>
					<tr>
						<td class="account_table_item">厚み</td>
						<td class="account_table_content">
							<?=$ring_thickness?><?=ring_thickness_unit?>
						</td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content">
							<input type="number" id="ring_thickness" name="ring_thickness" class="input_num" min="0" step="0.1" value="<?=$ring_thickness?>" required><?=ring_thickness_unit?>
							<div id="ring_thickness_error" class="error_text">入力してください。</div>
						</td>
					</tr>
				</table>
				<input type="hidden" id="user_id" name="user_id" value="<?=$user_id?>">
			</form>
		</div>
		<div class="details_flex_box">
			<span class="link_text" onclick="select_person('<?=$user_id?>')">戻る</span>
			<span>
				<span class="button_blue" onclick="update()">確定</span>
			</span>
		</div>
	</div>

</body>
</html>
