<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー新規登録";
$date = new DateTime();
$date = $date->format("YmdHis");

$pair_list = "";
$pair_array = [];

$pair_user_id = filter_input(INPUT_POST,"user_id");

try {
	$pdo = DBopen();

	// ペアを持たないアカウントを探す
	$select_sql = "SELECT * FROM user WHERE pair = ''";
	$select = $pdo->query($select_sql);
	while($row = $select->fetch()){
		$pair_id = $row["user_id"];
		$name = $row["name1"].$row["name2"];
		$mail = $row["mail"];
		$pair_array[$pair_id] = [
			"name" => $name,
			"mail" => $mail
		];

		$pair_list .=<<<EOD
		<tr>
			<td>{$name}</td>
			<td>{$mail}</td>
			<td><span class="pair_list_button modal-del" onclick="pair_select('{$pair_id}')">選択</span></td>
		</tr>
EOD;
	}

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$ring_type_options = "";
$count = 0;
foreach(ring_type_list as $value){
	$count++;
	$ring_type_options .= "<option value=\"{$count}\">{$value}</option>";
}

$json_pair_array = json_encode($pair_array);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<link rel="apple-touch-icon" href="../img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="../js/jquery.searcher.js"></script>
<script src="../js/script.js?v=<?=$date?>"></script>
<link href="../css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
const text_list = [
	"name1",
	"name2",
	/*
	"kana1",
	"kana2",
	*/
	"mail",
	"ring_size",
	"ring_width",
	"ring_thickness",
];
const error_list = [
	"name_error", // name1
	"name_error", // name2
	/*
	"kana_error", // kana1
	"kana_error", // kana2
	*/
	"mail_error", // mail
	"ring_size_error", // ring_size
	"ring_width_error", // ring_width
	"ring_thickness_error", // ring_thickness
];
const pair_list = <?=$json_pair_array?>;
var pair_check;
var submit_flag = true;
function create(){
	loading();
	let flag = check();
	console.log("--- return ---");
	console.log(flag);
	console.log("--- flag ---");
	console.log(submit_flag);
	if(flag && submit_flag){
		submit_flag = false;
		create_form.submit();
	}
	loading_end();
}
function check(){
	let flag = true;
	let focus_elm = "";
	let pair_focus_elm = "";

	let error_list_length = error_list.length;
	for(let i=0;i<error_list_length;i++){
		let elm_id = error_list[i];
		let error_elm = document.getElementById(elm_id);
		error_elm.style.display = "none";

		let pair_error_elm = document.getElementById("pair_"+elm_id);
		pair_error_elm.style.display = "none";
	}

	let text_list_length = text_list.length;
	for(let i=0;i<text_list_length;i++){
		let elm_id = text_list[i];
		let text_input_elm = document.getElementById(elm_id);
		let value = text_input_elm.value;
		if(value == ""){
			flag = false;
			let error_elm_id = error_list[i];
			let error_elm = document.getElementById(error_elm_id);
			error_elm.style.display = "block";
			if(focus_elm === ""){
				focus_elm = text_input_elm;
			}
		} else if(elm_id == "mail"){
			// 空ではなくメールアドレスの時
			let mail_check_result_elm = document.getElementById("mail_check_result");
			let mail_check_result = mail_check_result_elm.value;
			if(mail_check_result != 1){
				// メールアドレスの形式が間違っている, すでに登録済みである
				flag = false;
				if(focus_elm === ""){
					focus_elm = text_input_elm;
				}
			}
		}
	}

	if(pair_check == "2"){
		// ペアを新規登録する
		for(let i=0;i<text_list_length;i++){
			let elm_id = text_list[i];
			let text_input_elm = document.getElementById("pair_" + elm_id);
			let value = text_input_elm.value;
			if(value == ""){
				flag = false;
				let error_elm_id = error_list[i];
				let error_elm = document.getElementById("pair_" + error_elm_id);
				error_elm.style.display = "block";
				if(focus_elm === ""){
					focus_elm = text_input_elm;
				}
			} else if(elm_id == "mail"){
				// 空ではなくメールアドレスの時
				let mail_check_result_elm = document.getElementById("pair_mail_check_result");
				let mail_check_result = mail_check_result_elm.value;
				if(mail_check_result != 1){
					// メールアドレスの形式が間違っている, すでに登録済みである
					flag = false;
					if(focus_elm === ""){
						focus_elm = text_input_elm;
					}
				}
			}
		}
	} else if(pair_check == "3"){
		// ペアを既存のアカウントから登録する
	}

	if(focus_elm !== ""){
		focus_elm.focus();
	}
	return flag;
}

function check_mail(e,p){
	let value = e.value;
	let flag;
	let pattern = /^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]+.[A-Za-z0-9]+$/;
	let pair = "";

	if(p){
		// pairのチェックである
		pair = "pair_";
	}

	let mail_check_error_elm = document.getElementById(pair + "mail_check_error");
	mail_check_error_elm.style.display = "none";

	let mail_exist_error_elm = document.getElementById(pair + "mail_exist_error");
	mail_exist_error_elm.style.display = "none";

	let mail_check_result_elm = document.getElementById(pair + "mail_check_result");
	mail_check_result_elm.value = "";

	if(pattern.test(value)){
		$.ajax({
			url : "./request/check_new_account.php",
			type : "POST",
			dataType:"text",
			data : {'mail':value},
			//timeout:10000,
		}).done(function(data){
			if(data){
				// 存在しない
				flag = 1;
			} else {
				// 存在する
				flag = 0;
				mail_exist_error_elm.style.display = "block";
			}
			mail_check_result_elm.value = flag;
		}).fail(function(XMLHttpRequest, textStatus, errorThrown) {
			// 失敗時の処理
			flag = 0;
			return flag;
		})
	} else {
		flag = 0;
		mail_check_error_elm.style.display = "block";
		mail_check_result_elm.value = flag;
	}
}

function pair_change(){
	let pair_table = document.getElementById("pair_table");
	let pair_table2 = document.getElementById("pair_table2");
	pair_check = $("input[name='pair_select']:checked").val();
	if(pair_check == "2"){
		// ペアを新規作成する
		pair_table.style.display = "table";
		pair_table2.style.display = "none";
	} else if(pair_check == "3"){
		// ペアを登録する
		pair_table.style.display = "none";
		pair_table2.style.display = "table";
	} else {
		// ペアの新規作成はしない
		pair_table.style.display = "none";
		pair_table2.style.display = "none";
	}
}

function pair_select(e){
	let pair_data = pair_list[e];
	let pair_name = pair_data.name;
	let pair_mail = pair_data.mail;

	let select_pair_tr = document.getElementById("select_pair_tr");
	select_pair_tr.style.display = "none";

	let pair_selected_name_tr = document.getElementById("pair_selected_name_tr");
	pair_selected_name_tr.style.display = "table-row";
	let pair_selected_mail_tr = document.getElementById("pair_selected_mail_tr");
	pair_selected_mail_tr.style.display = "table-row";
	let change_pair_tr = document.getElementById("change_pair_tr");
	change_pair_tr.style.display = "table-row";

	let pair_id_elm = document.getElementById("pair_id");
	pair_id_elm.value = e;

	let pair_name_elm = document.getElementById("pair_selected_name");
	pair_name_elm.innerText = pair_name;

	let pair_selected_mail = document.getElementById("pair_selected_mail");
	pair_selected_mail.innerText = pair_mail;
}

window.onload = function(){
	pair_change();

	$("#pair_list").searcher({
		inputSelector: "#pair_search"
	});

	<?= !empty($pair_user_id) ? "pair_select('{$pair_user_id}');" : "";?>
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="main">
		<form id="create_form" name="create_form" method="post" action="create_new_account_posted.php" autocomplete="off">
			<table class="create_new_account_table">
				<tr>
					<td class="create_table_head" colspan="2">ユーザー作成</td>
				</tr>
				<tr>
					<td class="account_table_item">名前</td>
					<td class="account_table_content">
						<span class="account_name_text">姓</span><input type="text" class="half_width" id="name1" name="name1" required>
						<span class="account_name_text">名</span><input type="text" class="half_width" id="name2" name="name2" required>
						<div id="name_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<!--
				<tr>
					<td class="account_table_item">かな</td>
					<td class="account_table_content">
						<span class="account_name_text">姓</span><input type="text" class="half_width" id="kana1" name="kana1" required>
						<span class="account_name_text">名</span><input type="text" class="half_width" id="kana2" name="kana2" required>
						<div id="kana_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				-->
				<tr>
					<td class="account_table_item">性別</td>
					<td class="account_table_content">
						<label for="gender1"><input type="radio" id="gender1" name="gender" value="1" required checked>男性</label>
						<label for="gender2"><input type="radio" id="gender2" name="gender" value="2" required>女性</label>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">メールアドレス</td>
					<td class="account_table_content">
						<input type="text" id="mail" name="mail" class="half_width" onchange="check_mail(this,false)" required>
						<div id="mail_error" class="error_text">入力してください。</div>
						<div id="mail_check_error" class="error_text">正しいメールアドレスを入力してください。</div>
						<div id="mail_exist_error" class="error_text">すでに登録済みのメールアドレスです。</div>
						<input type="hidden" id="mail_check_result">
					</td>
				</tr>
				<tr>
					<td class="account_table_item">指輪の形状</td>
					<td class="account_table_content">
						<select id="ring_type" name="ring_type" required>
							<?= $ring_type_options ?>
						</select>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">指輪のサイズ</td>
					<td class="account_table_content">
						<input type="number" id="ring_size" name="ring_size" class="input_num" min="0" step="0.1" required><?=ring_size_unit?>
						<div id="ring_size_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">幅</td>
					<td class="account_table_content">
						<input type="number" id="ring_width" name="ring_width" class="input_num" min="0" step="0.1" required><?=ring_width_unit?>
						<div id="ring_width_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">厚み</td>
					<td class="account_table_content">
						<input type="number" id="ring_thickness" name="ring_thickness" class="input_num" min="0" step="0.1" required><?=ring_thickness_unit?>
						<div id="ring_thickness_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">備考</td>
					<td class="account_table_content">
						<textarea id="remarks" name="remarks"></textarea>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">ペア</td>
					<td class="account_table_content">
						<label for="pair2"><input type="radio" id="pair2" name="pair_select" value="2" onchange="pair_change()" required<?= empty($pair_user_id) ? " checked" : "";?>>新しくペアを作る</label>
						<label for="pair1"><input type="radio" id="pair1" name="pair_select" value="1" onchange="pair_change()" required>ペアを作成しない</label>
						<label for="pair3"><input type="radio" id="pair3" name="pair_select" value="3" onchange="pair_change()" required<?= !empty($pair_user_id) ? " checked" : "";?>>既存のアカウントからペアを作る</label>
					</td>
				</tr>
			</table>

			<table id="pair_table" class="create_new_account_table nodisp">
				<tr>
					<td class="create_table_head" colspan="2">ペア作成</td>
				</tr>
				<tr>
					<td class="account_table_item">名前</td>
					<td class="account_table_content">
						<span class="account_name_text">姓</span><input type="text" class="half_width" id="pair_name1" name="pair_name1" required>
						<span class="account_name_text">名</span><input type="text" class="half_width" id="pair_name2" name="pair_name2" required>
						<div id="pair_name_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<!--
				<tr>
					<td class="account_table_item">かな</td>
					<td class="account_table_content">
						<span class="account_name_text">姓</span><input type="text" class="half_width" id="pair_kana1" name="pair_kana1" required>
						<span class="account_name_text">名</span><input type="text" class="half_width" id="pair_kana2" name="pair_kana2" required>
						<div id="pair_kana_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				-->
				<tr>
					<td class="account_table_item">性別</td>
					<td class="account_table_content">
						<label for="pair_gender1"><input type="radio" id="pair_gender1" name="pair_gender" value="1" required>男性</label>
						<label for="pair_gender2"><input type="radio" id="pair_gender2" name="pair_gender" value="2" required checked>女性</label>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">メールアドレス</td>
					<td class="account_table_content">
						<input type="text" id="pair_mail" name="pair_mail" class="half_width" onchange="check_mail(this,true)" required>
						<div id="pair_mail_error" class="error_text">入力してください。</div>
						<div id="pair_mail_check_error" class="error_text">正しいメールアドレスを入力してください。</div>
						<div id="pair_mail_exist_error" class="error_text">すでに登録済みのメールアドレスです。</div>
						<input type="hidden" id="pair_mail_check_result">
					</td>
				</tr>
				<tr>
					<td class="account_table_item">指輪の形状</td>
					<td class="account_table_content">
						<select id="pair_ring_type" name="pair_ring_type" required>
							<?= $ring_type_options ?>
						</select>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">指輪のサイズ</td>
					<td class="account_table_content">
						<input type="number" id="pair_ring_size" name="pair_ring_size" class="input_num" min="0" step="0.1" required><?=ring_size_unit?>
						<div id="pair_ring_size_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">幅</td>
					<td class="account_table_content">
						<input type="number" id="pair_ring_width" name="pair_ring_width" class="input_num" min="0" step="0.1" required><?=ring_width_unit?>
						<div id="pair_ring_width_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">厚み</td>
					<td class="account_table_content">
						<input type="number" id="pair_ring_thickness" name="pair_ring_thickness" class="input_num" min="0" step="0.1" required><?=ring_thickness_unit?>
						<div id="pair_ring_thickness_error" class="error_text">入力してください。</div>
					</td>
				</tr>
				<tr>
					<td class="account_table_item">備考</td>
					<td class="account_table_content">
						<textarea id="pair_remarks" name="pair_remarks"></textarea>
					</td>
				</tr>
			</table>

			<table id="pair_table2" class="create_new_account_table nodisp">
				<tr>
					<td class="create_table_head" colspan="2">ペア登録</td>
				</tr>
				<tr id="select_pair_tr">
					<td colspan="2"><span class="blue_text" onclick="modal('pair')">選択</span></td>
				</tr>
				<tr id="pair_selected_name_tr" class="nodisp">
					<td class="account_table_item">名前</td>
					<td id="pair_selected_name" class="account_table_content"></td>
				</tr>
				<tr id="pair_selected_mail_tr" class="nodisp">
					<td class="account_table_item">メールアドレス</td>
					<td id="pair_selected_mail" class="account_table_content"></td>
				</tr>
				<tr id="change_pair_tr" class="nodisp">
					<td colspan="2"><span class="blue_text" onclick="modal('pair')">変更</span></td>
				</tr>
			</table>

			<input type="hidden" id="pair_id" name="pair_id" value="<?=$pair_user_id?>">

			<p class="center">
				<span class="button_blue" onclick="create();">作成する</span>
			</p>
		</form>
	</div>

	<div id="modal-pair" class="modal-main">
		<div id="modal-pair-content" class="modal-content">
			<div class="modal-header">ペアの選択</div>
			<div class="modal-search"><input type="text" id="pair_search"></div>
			<div class="modal-items">
				<table id="pair_list">
					<thead>
						<tr>
							<th>名前</th>
							<th>メールアドレス</th>
						</tr>
					</thead>
					<tbody>
						<?= $pair_list ?>
					</tbody>
				</table>
			</div>
			<div class="modal-action">
				<span></span>
				<span>
					<span class="modal-del">キャンセル</span>
				</span>
			</div>
		</div>
	</div>

</body>
</html>
