<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "お客様情報の入力/変更";

$date = new DateTime();
$date = $date->format("YmdHis");

if(isset($_SESSION["info"]["save"])){
	// 保存した
	$saved_flag = true;
	unset($_SESSION["info"]["save"]);
} else {
	$saved_flag = false;
}

// 初回の登録かどうかを確認する
// 入力データがなければ空である
try {
	$pdo = DBopen();

	$select_sql = "SELECT * FROM user WHERE user_id = ?";
	$select = $pdo->prepare($select_sql);
	$select->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$select->execute();

	if($row = $select->fetch()){
		$name1 = $row["name1"];
		$name2 = $row["name2"];

		$ring_type = $row["ring_type"];
		$ring_size = $row["ring_size"];
		$ring_width = $row["ring_width"];
		$ring_thickness = $row["ring_thickness"];

		$fixed_ring_type = $row["fixed_ring_type"];
		$fixed_ring_size = $row["fixed_ring_size"];
		$fixed_ring_width = $row["fixed_ring_width"];
		$fixed_ring_thickness = $row["fixed_ring_thickness"];

		$handedness = $row["handedness"];
		$joint = $row["joint"];
		$working = $row["working"];
		$frequency = $row["frequency"];
		$alcohol = $row["alcohol"];
		$taste = $row["taste"];

		$ring_type_key = intval($ring_type) - 1;
		if($ring_type_key < 0){
			$ring_type_key = 0;
		}
		$ring_type = ring_type_list[$ring_type_key];

		$ring_size .= ring_size_unit;
		$ring_width .= ring_width_unit;
		$ring_thickness .= ring_thickness_unit;


	} else {
		throw new RuntimeException("対象が存在しない");
	}

	if(empty($handedness) || empty($joint) || empty($frequency) || empty($alcohol) || empty($taste)){
		$info_flag = "Y"; // Y -> 初回, N -> それ以外
	} else {
		$info_flag = "N"; // Y -> 初回, N -> それ以外
	}

	if($info_flag === "Y"){
		$info_submit_text = "保存して次へ";
	} else {
		$info_submit_text = "保存する";
	}
} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
window.onload = function(){
	<?php
	if($saved_flag){
	?>
	popup("saved");
	<?php
	}
	?>
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>
	<div id="main">
		<form id="post_form" name="post_form" method="post" action="">
			<table id="info_table">
				<tr>
					<td>お名前</td>
					<td><span class="sei"><?=$name1?></span><span class="mei"><?=$name2?></span>様</td>
				</tr>
				<tr>
					<td>指輪形状</td>
					<td><?=$ring_type?></td>
				</tr>
				<tr>
					<td>サイズ</td>
					<td><?=$ring_size?></td>
				</tr>
				<tr>
					<td>幅</td>
					<td><?=$ring_width?></td>
				</tr>
				<tr>
					<td>厚み</td>
					<td><?=$ring_thickness?></td>
				</tr>
				<tr>
					<td>利き手</td>
					<td>
						<select id="hand" name="hand">
							<option value="1"<?=$handedness === "1" ? " selected" : ""?>>右手</option>
							<option value="2"<?=$handedness === "2" ? " selected" : ""?>>左手</option>
						</select>
					</td>
				</tr>
				<tr>
					<td>薬指の節</td>
					<td>
						<select id="joint" name="joint">
							<option value="1"<?=$joint === "1" ? " selected" : ""?>>あり</option>
							<option value="2"<?=$joint === "2" ? " selected" : ""?>>少しあり</option>
							<option value="3"<?=$joint === "3" ? " selected" : ""?>>なし</option>
						</select>
					</td>
				</tr>
				<!--
				<tr>
					<td>仕事で指輪</td>
					<td>
						<select id="working" name="working">
							<option value="1"<?=$working === "1" ? " selected" : ""?>>外す必要あり</option>
							<option value="2"<?=$working === "2" ? " selected" : ""?>>外さなくて大丈夫</option>
						</select>
					</td>
				</tr>
				-->
				<tr>
					<td>外す頻度</td>
					<td>
						<select id="frequency" name="frequency">
							<option value="1"<?=$frequency === "1" ? " selected" : ""?>>多い、仕事で外す必要あり</option>
							<option value="2"<?=$frequency === "2" ? " selected" : ""?>>時々外す</option>
							<option value="3"<?=$frequency === "3" ? " selected" : ""?>>少ない、外さない</option>
						</select>
					</td>
				</tr>
				<tr>
					<td>お酒</td>
					<td>
						<select id="alcohol" name="alcohol">
							<option value="1"<?=$alcohol === "1" ? " selected" : ""?>>よく飲む</option>
							<option value="2"<?=$alcohol === "2" ? " selected" : ""?>>たまに飲む</option>
							<option value="3"<?=$alcohol === "3" ? " selected" : ""?>>飲まない</option>
						</select>
					</td>
				</tr>
				<tr>
					<td>フィット感の好み</td>
					<td>
						<select id="taste" name="taste">
							<option value="1"<?=$taste === "1" ? " selected" : ""?>>きつめ</option>
							<option value="2"<?=$taste === "2" ? " selected" : ""?>>多少きつめ</option>
							<option value="3"<?=$taste === "3" ? " selected" : ""?>>ふつう</option>
							<option value="4"<?=$taste === "4" ? " selected" : ""?>>多少ゆるめ</option>
							<option value="5"<?=$taste === "5" ? " selected" : ""?>>ゆるめ</option>
						</select>
					</td>
				</tr>
			</table>
			<input type="hidden" id="info_flag" name="info_flag" value="<?=$info_flag?>">
		</form>
		<div id="footer">
			<div id="footer_button_next" onclick="post_move('info_save')"><?=$info_submit_text?></div>
		</div>
	</div>

	<?php
	if($saved_flag){
	?>
	<div id="saved" class="popup-main">
		<p>保存しました。</p>
		<p class="popup-button-box"><span class="popup-close button">閉じる</span></p>
	</div>
	<?php
	}
	?>
</body>
</html>
