<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

//require_once './include/include.php';
require_once './include/server_check.php';
require_once './include/config.php';

$title = "トップ";

$date = new DateTime();
$date = $date->format("YmdHis");
/*
try {
	$pdo = DBopen();

	// 今までにどれだけ記録があるかを調べる
	$count_asa_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '04:00:00' AND created_time < '11:00:00' AND deleted != 1";
	$count_asa = $pdo->prepare($count_asa_sql);
	$count_asa->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$count_asa->execute();
	$count_asa_result = $count_asa->fetchcolumn();

	$count_hiru_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '11:00:00' AND created_time < '17:00:00' AND deleted != 1";
	$count_hiru = $pdo->prepare($count_hiru_sql);
	$count_hiru->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$count_hiru->execute();
	$count_hiru_result = $count_hiru->fetchcolumn();

	// 夜の記録の場合は0～4時の記録を前日にするために調整する
	$count_yoru_sql = "SELECT COUNT(DISTINCT CAST((created - INTERVAL 4 HOUR) AS DATE)) FROM report WHERE user_id = ? AND (created_time < '04:00:00' OR created_time >= '17:00:00') AND deleted != 1";
	$count_yoru = $pdo->prepare($count_yoru_sql);
	$count_yoru->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$count_yoru->execute();
	$count_yoru_result = $count_yoru->fetchcolumn();

} catch (Exception $e) {
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}
*/

$count_asa_result = rand(0,5);
$count_hiru_result = rand(0,5);
$count_yoru_result = rand(0,5);

if($count_asa_result >= 5 && $count_hiru_result >= 5 && $count_yoru_result >= 5){
	// 推奨回数を超えている
	$stamp_rally_text = stamp_rally_finished_text;
	$finish_img = "./stamps/finish.png";
	$frame_img = "./stamps/frame.png";
} else {
	// 推奨回数を終えていない
	$stamp_rally_text = stamp_rally_text;
	$finish_img = "";
	$frame_img = "";
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js?v=<?=$date?>"></script>
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>
	<div id="main">
		<div id="stamp_box">
			<img src="./stamps/base.png" id="base_img">
			<img src="./stamps/main.png" id="main_img">
			<?php
			for($i=0;$i<5;$i++){
				$count = $i + 1;
				if($count <= $count_asa_result){
					// すでに表示済みの画像
					$src1 = "./stamps/item1_{$count}.png";
				} else {
					$src1 = "";
				}
				if($count <= $count_hiru_result){
					// すでに表示済みの画像
					$src2 = "./stamps/item2_{$count}.png";
				} else {
					$src2 = "";
				}
				if($count <= $count_yoru_result){
					// すでに表示済みの画像
					$src3 = "./stamps/item3_{$count}.png";
				} else {
					$src3 = "";
				}
				echo "<img src=\"{$src1}\" id=\"accessories_img_1_{$i}\" class=\"accessory_img\">";
				echo "<img src=\"{$src2}\" id=\"accessories_img_2_{$i}\" class=\"accessory_img\">";
				echo "<img src=\"{$src3}\" id=\"accessories_img_3_{$i}\" class=\"accessory_img\">";
			}
			?>
			<img src="<?=$finish_img?>" id="finish_img">
			<img src="<?=$frame_img?>" id="frame_img">
		</div>
		<p id="count_box" class="small_text">
			<?=$stamp_rally_text?>
		</p>
		<ul id="top_list">
			<li><a href="./report.php" class="link_text">記録を取る</a></li>
			<li><a href="./list.php" class="link_text">記録の一覧</a></li>
			<!--<li><a href="./aggregate.php" class="link_text">集計結果とサイズ調整推奨</a></li>-->
		</ul>
	</div>
</body>
</html>
