<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

// グラフはデータが集まってから
$graph_flag = false;

$title = "解析結果";
$date = new DateTime();
$date = $date->format("YmdHis");

$user_id = $_SESSION["user"];

try {
	$pdo = DBopen();

	// 集計
	// 今までにどれだけ記録があるかを調べる
	$count_asa_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '04:00:00' AND created_time < '11:00:00' AND deleted != 1";
	$count_asa = $pdo->prepare($count_asa_sql);
	$count_asa->bindValue(1,$user_id,PDO::PARAM_STR);
	$count_asa->execute();
	$count_asa_result = $count_asa->fetchcolumn();

	$count_hiru_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '11:00:00' AND created_time < '17:00:00' AND deleted != 1";
	$count_hiru = $pdo->prepare($count_hiru_sql);
	$count_hiru->bindValue(1,$user_id,PDO::PARAM_STR);
	$count_hiru->execute();
	$count_hiru_result = $count_hiru->fetchcolumn();

	// 夜の記録の場合は0～4時の記録を前日にするために調整する
	$count_yoru_sql = "SELECT COUNT(DISTINCT CAST((created - INTERVAL 4 HOUR) AS DATE)) FROM report WHERE user_id = ? AND (created_time < '04:00:00' OR created_time >= '17:00:00') AND deleted != 1";
	$count_yoru = $pdo->prepare($count_yoru_sql);
	$count_yoru->bindValue(1,$user_id,PDO::PARAM_STR);
	$count_yoru->execute();
	$count_yoru_result = $count_yoru->fetchcolumn();

	$another_data_list = [
		"1" => 0, // 1.5以上アップ
		"2" => 0, // 0.5 ~ 1 アップ
		"3" => 0, // 変わらない
		"4" => 0, // 0.5 ~ 1 ダウン
		"5" => 0, // 1.5以上ダウン
	];
	$matrix_flag = false;

	$all_count = $count_asa_result + $count_hiru_result + $count_yoru_result;

	//if($count_asa_result >= 5 && $count_hiru_result >= 5 && $count_yoru_result >= 5){
	if($all_count > 2){
		// 十分に集計があれば
		require_once './include/calc.php';
		$return_data = diagnosis($pdo,$user_id);
		$user_type1 = $return_data["user_type1"];
		$user_type1_value = $return_data["user_type1_value"];
		$user_type2 = $return_data["user_type2"];
		$user_type2_value = $return_data["user_type2_value"];
		$matrix_flag = true;

		// 同じ分類の人がどのようにしたか？
		// サイズアップ, 変更なし, サイズダウン
		$select_another_data_sql = "SELECT * FROM user WHERE user_id != ? AND fixed_date != ? AND user_type1 = ? AND user_type2 = ?";
		$select_another_data = $pdo->prepare($select_another_data_sql);
		$select_another_data->bindValue(1,$user_id,PDO::PARAM_STR);
		$select_another_data->bindValue(2,default_date,PDO::PARAM_STR);
		$select_another_data->bindValue(3,$user_type1,PDO::PARAM_STR);
		$select_another_data->bindValue(4,$user_type2,PDO::PARAM_STR);
		$select_another_data->execute();
		while($row = $select_another_data->fetch()){
			$another_ring_size = $row["ring_size"];
			$another_fixed_ring_size = $row["fixed_ring_size"];
			$another_ring_size_changed = $another_fixed_ring_size - $another_ring_size;
			// 0は変更なし, +0.1～+0.5は+0.5, +0.6～+1.0は+1, +1.1～は+1.5以上
			if($another_ring_size_changed > 1){
				$size_changed_key = 1;
			} else if($another_ring_size_changed > 0 && $another_ring_size_changed <= 1){
				$size_changed_key = 2;
			} else if($another_ring_size_changed === 0){
				$size_changed_key = 3;
			} else if($another_ring_size_changed < 0 && $another_ring_size_changed >= -1){
				$size_changed_key = 4;
			} else if($another_ring_size_changed < -1){
				$size_changed_key = 5;
			} else {
				continue;
			}
			$another_data_list[$size_changed_key]++;
			// グラフはデータが集まってから
			//$graph_flag = true;
		}
	}

} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

if($matrix_flag){
	// 集計を出す
	$item_count = count($another_data_list);
	$another_data_values_json = json_encode($another_data_list);

	$item1_count = $another_data_list[1];
	$item2_count = $another_data_list[2];
	$item3_count = $another_data_list[3];
	$item4_count = $another_data_list[4];
	$item5_count = $another_data_list[5];

	$item_total = $item1_count + $item2_count + $item3_count + $item4_count + $item5_count;
	if($item_total != 0){
		$item1_percent = round(($item1_count / $item_total * 100),1);
		$item2_percent = round(($item2_count / $item_total * 100),1);
		$item3_percent = round(($item3_count / $item_total * 100),1);
		$item4_percent = round(($item4_count / $item_total * 100),1);
		$item5_percent = round(($item5_count / $item_total * 100),1);

		$item1_text = "{$item1_percent}%".graph_item_legend_list[0];
		$item2_text = "{$item2_percent}%".graph_item_legend_list[1];
		$item3_text = "{$item3_percent}%".graph_item_legend_list[2];
		$item4_text = "{$item4_percent}%".graph_item_legend_list[3];
		$item5_text = "{$item5_percent}%".graph_item_legend_list[4];
	} else {
		$item1_percent = 0;
		$item2_percent = 0;
		$item3_percent = 0;
		$item4_percent = 0;
		$item5_percent = 0;

		$item1_text = "{$item1_percent}%".graph_item_legend_list[0];
		$item2_text = "{$item2_percent}%".graph_item_legend_list[1];
		$item3_text = "{$item3_percent}%".graph_item_legend_list[2];
		$item4_text = "{$item4_percent}%".graph_item_legend_list[3];
		$item5_text = "{$item5_percent}%".graph_item_legend_list[4];
	}



	$matrix = "";
	$matrix .= "<tr><td class=\"noborder\"></td><td class=\"noborder2\"></td><td id=\"matrix_user_type2\" colspan=\"5\">むくみ率（％）</td></tr>";
	for($i=0;$i<6;$i++){
		for($j=0;$j<6;$j++){
			if($j === 0){
				// 1列目
				// フィット率をつける
				$matrix .= "<tr>";
				switch($i){
					case 0:
					$matrix .= "<td class=\"noborder\"></td>";
					$matrix .= "<td class=\"noborder2\"></td>";
					break;
					case 1:
					$matrix .= "<td id=\"matrix_user_type1\" rowspan=\"5\"><span class=\"vertical\">リングフィット率（％）</span></td>";
					$user_type1_min = "";
					$user_type1_max = user_type1_condition_list[0];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 2:
					$user_type1_min = user_type1_condition_list[0];
					$user_type1_max = user_type1_condition_list[1];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 3:
					$user_type1_min = user_type1_condition_list[1];
					$user_type1_max = user_type1_condition_list[2];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 4:
					$user_type1_min = user_type1_condition_list[2];
					$user_type1_max = user_type1_condition_list[3];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 5:
					$user_type1_min = user_type1_condition_list[3];
					$user_type1_max = "";
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					default:
					$matrix .= "<td></td>";
					break;
				}
			} else if($i === 0){
				// 1行目
				// むくみ率をつける
				switch($j){
					case 0:
					// $j === 0 はフィット率でつけている
					break;
					case 1:
					$user_type2_min = "";
					$user_type2_max = user_type2_condition_list[0];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 2:
					$user_type2_min = user_type2_condition_list[0];
					$user_type2_max = user_type2_condition_list[1];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 3:
					$user_type2_min = user_type2_condition_list[1];
					$user_type2_max = user_type2_condition_list[2];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 4:
					$user_type2_min = user_type2_condition_list[2];
					$user_type2_max = user_type2_condition_list[3];
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 5:
					$user_type2_min = user_type2_condition_list[3];
					$user_type2_max = "";
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					default:
					$matrix .= "<td></td>";
					break;
				}
			} else {
				if($user_type1 == $i && $user_type2 == $j){
					// 診断結果
					$matrix .= "<td id=\"matrix_selected\">★</td>";
				} else {
					$matrix .= "<td></td>";
				}
			}

			if($j === 5){
				$matrix .= "</tr>";
			}
		}
		$matrix .= "</tr>";
	}
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="./c3-0.7.18/c3.css" rel="stylesheet">
<script src="./d3/d3.min.js"></script>
<script src="./c3-0.7.18/c3.min.js"></script>
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
function graph(){
	<?php
	if($graph_flag){
	?>
	var values = <?php echo $another_data_values_json; ?>;
	var columns = [];
	var names = {};
	let sum = 0;

	for(let i=1;i<=values.length;i++){
		let value = values[i];
		let data_num = "data" + i;
		let data_name = "データ" + i;
		let column = [data_num, value];
		columns.push(column);
		names[data_num] = data_name;
		sum += value;
	}

	pie = c3.generate({
		bindto: '#pie',
		data: {
			columns: [
				<?php
				for($i=1;$i<=$item_count;$i++){
					$column = $another_data_list[$i];
					$num = $i;

					echo "['data{$num}', {$column}],\n";
				}
				?>
			],
			names: {
				<?php
				for($i=0;$i<$item_count;$i++){
					$item_name = graph_item_list[$i];
					$num = $i + 1;

					echo "data{$num}: \"{$item_name}\",\n";
				}
				?>
			},
			type : 'pie',
			order : null,
			/*
			colors: {
				data1: '#ff0000',
				data2: '#00ff00',
				data3: '#0000ff'
			},

			onclick: function (d, i) { console.log("onclick", d, i); },
			onmouseover: function (d, i) { console.log("onmouseover", d, i); },
			onmouseout: function (d, i) { console.log("onmouseout", d, i); }
			*/
		},
		legend: {
			//position: 'right',
			item: {
				onclick: function(data){
					// do not toggle
				}
			}
		},
	});
	<?php
	}
	?>
}
window.onload = function(){
	graph();
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>
	<div id="main">
		<div class="content_box">
			<?php
			if($matrix_flag){
			?>
			<div id="fit_text_box">
				<div class="fit_text_block">
					<table class="fit_text_table">
						<tr class="noborder">
							<td class="fit_text_head">リングフィット率</td>
						</tr>
						<tr class="noborder">
							<td class="value_display_body">
								<span class="type_value_display"><?=$user_type1_value?><span class="percent">%</span></span>
							</td>
						</tr>
					</table>
					<table class="fit_text_table">
						<tr>
							<td class="fit_text_head2" colspan="2">リングフィット率の目安</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type1_condition_list[0]?></span>%</td>
							<td class="fit_text">きつめ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type1_condition_list[0]?></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type1_condition_list[1]?></span>%</td>
							<td class="fit_text">多少きつめ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type1_condition_list[1]?></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type1_condition_list[2]?></span>%</td>
							<td class="fit_text">適正</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type1_condition_list[2]?></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type1_condition_list[3]?></span>%</td>
							<td class="fit_text">多少ゆるめ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type1_condition_list[3]?>%</span><span class="fit_text_spans">-</span><span class="fit_text_spans"></span></td>
							<td class="fit_text">ゆるめ</td>
						</tr>
					</table>
				</div>
				<div class="fit_text_block">
					<table class="fit_text_table">
						<tr class="noborder">
							<td class="fit_text_head">指のむくみ率</td>
						</tr>
						<tr class="noborder">
							<td class="value_display_body">
								<span class="type_value_display"><?=$user_type2_value?><span class="percent">%</span></span>
							</td>
						</tr>
					</table>
					<table class="fit_text_table">
						<tr>
							<td class="fit_text_head2" colspan="2">むくみ率の目安</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type2_condition_list[0]?></span>%</td>
							<td class="fit_text">わずかなむくみ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type2_condition_list[0]?></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type2_condition_list[1]?></span>%</td>
							<td class="fit_text">多少のむくみ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type2_condition_list[1]?></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type2_condition_list[2]?></span>%</td>
							<td class="fit_text">大きなむくみ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type2_condition_list[2]?></span><span class="fit_text_spans">-</span><span class="fit_text_spans"><?=user_type2_condition_list[3]?></span>%</td>
							<td class="fit_text">かなり大きなむくみ</td>
						</tr>
						<tr>
							<td class="fit_text_item"><span class="fit_text_spans"><?=user_type2_condition_list[3]?>%</span><span class="fit_text_spans">-</span><span class="fit_text_spans"></span></td>
							<td class="fit_text">極端なむくみ</td>
						</tr>
					</table>
				</div>
			</div>
			<div id="user_type_matrix_box" class="block_margin">
				<table id="user_type_matrix">
					<?=$matrix?>
				</table>
			</div>
			<?php
			if($graph_flag){
			?>
			<div class="separation">同タイプの方のサイズ変更データ</div>
			<div id="pie" class="block_margin"></div>
			<div id="pie_text_list">
				<ul>
					<li><?=$item1_text?></li>
					<li><?=$item2_text?></li>
					<li><?=$item3_text?></li>
					<li><?=$item4_text?></li>
					<li><?=$item5_text?></li>
				</ul>
			</div>
			<?php
			}
			?>
			<?php
			} else {
			?>
			<p>データが集まり次第開放予定です。</p>
			<?php
			}
			?>
		</div>
	</div>
</body>
</html>
